/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "crosshair.h"
#include "event_handler.h"

#include "graphics_engine.h"
#include "glincl.h"
#include "p_node.h"
#include "state.h"

#include <iostream>

using namespace std;


/**
   \brief standard constructor
*/
Crosshair::Crosshair ()
{
  this->setClassID(CL_CROSSHAIR, "Crosshair");
  this->setName("Crosshair");

  EventHandler::getInstance()->subscribe(this, ES_GAME, EV_MOUSE_MOTION);

}


/**
   \brief standard deconstructor
*/
Crosshair::~Crosshair ()
{
  // delete what has to be deleted here
  EventHandler::getInstance()->unsubscribe(this);
}

void Crosshair::process(const Event &event)
{
  if  (event.type == EV_MOUSE_MOTION)
  {
    this->position2D[0] = event.x;
    this->position2D[1] = event.y;
  }

  /*
  GLdouble z;
  GLdouble objX, objY, objZ;
  glReadPixels (event.x, event.y, 1, 1, GL_DEPTH_COMPONENT, GL_DOUBLE, &z);


  if (gluUnProject(event.x,
      event.y,
      10,
      GraphicsEngine::modMat,
      GraphicsEngine::projMat,
      GraphicsEngine::viewPort,
      &objX,
      &objY,
      &objZ ))
    PRINT(0)("screen %d %d -> obj(%f/%f/%f)\n", event.x, event.y, objX, objY, objZ);
  else
    PRINT(0)("shit\n");
*/
}


void Crosshair::draw() const
{
  /*
  const PNode* camera = State::getInstance()->getCamera();  //!< \todo MUST be different
  Vector cameraPos = camera->getAbsCoor();
  Vector cameraTargetPos = State::getInstance()->getCameraTarget()->getAbsCoor();
  Vector view = cameraTargetPos - cameraPos;
  Vector up = Vector(0, 1, 0);
  up = camera->getAbsDir().apply(up);
  Vector h = up.cross(view);
  Vector v = h.cross(view);
  h.normalize();
  v.normalize();

  float px = (position2D[0]-GraphicsEngine::getInstance()->getResolutionX()/2)*.05;
  float py = -(position2D[1]-GraphicsEngine::getInstance()->getResolutionY()/2)*.05;

  glBegin(GL_TRIANGLES);
  glVertex3f(cameraTargetPos.x - h.x*px - v.x*py,
  cameraTargetPos.y - h.y*px - v.y*py,
  cameraTargetPos.z - h.z*px - v.z*py);

  glVertex3f(cameraTargetPos.x - h.x*(px+1) - v.x*py,
  cameraTargetPos.y - h.y*(px+1) - v.y*py,
  cameraTargetPos.z - h.z*(px+1) - v.z*py);

  glVertex3f(cameraTargetPos.x - h.x*px - v.x*(py+1),
  cameraTargetPos.y - h.y*px - v.y*(py+1),
  cameraTargetPos.z - h.z*px - v.z*(py+1));

  glEnd();

  */


  GraphicsEngine::storeMatrices();

  float z;
  glReadPixels ((int)position2D[0], GraphicsEngine::getInstance()->getResolutionY()-(int)position2D[1]-1, 1, 1, GL_DEPTH_COMPONENT, GL_FLOAT, &z);


  printf("%f %f %f\n", (int)position2D[0], (int)position2D[1], z);

  //cout << z <<"  "<< scale << "  "  << bias<< endl;

  GLdouble objX, objY, objZ;
  gluUnProject(position2D[0],
               GraphicsEngine::getInstance()->getResolutionY()-position2D[1]-1,
               .5,
               GraphicsEngine::modMat,
               GraphicsEngine::projMat,
               GraphicsEngine::viewPort,
               &objX,
               &objY,
               &objZ );

  glBegin(GL_TRIANGLES);
  glColor3f(1,0,0);
  glVertex3f(objX, objY, objZ);
  glVertex3f(objX, objY+1, objZ);
  glVertex3f(objX, objY, objZ+1);
  glEnd();
}
