/*!
    \file proto_class.h
    \brief Definition of ...

*/

#ifndef _QUADTREE_NODE_H
#define _QUADTREE_NODE_H

#include "base_object.h"
#include "vector.h"

// FORWARD DEFINITION
class Quadtree;
class QuadtreeNode;

//! A class for a Quadtree Node representation
class QuadtreeNode : public BaseObject {

 public:
  QuadtreeNode(sTriangleExt* triangles, int numTriangles, Quadtree* quadtree);
  virtual ~QuadtreeNode();

  void separateNode();

  void drawTree(int depth, int drawMode) const;


 private:
   Quadtree*                       quadtree;           //!< reference to the quadtree
   Vector                          center;             //!< center coordinate of the quadtree node - relative coordinates in model space(!)
   float                           axisLength;         //!< axis length of the quadtree
   float                           maxHeigth;          //!< max height of the model in the quadtree

   sTriangleExt*                   triangles;          //!< reference to the triangles of the node
   unsigned int                    numTriangles;       //!< number of triangles of the Node
   modelInfo*                      pModelInfo;         //!< reference to the modelInfo of the object

   QuadtreeNode*                   nodeA;              //!< reference to the node A
   QuadtreeNode*                   nodeB;              //!< reference to the node B
   QuadtreeNode*                   nodeC;              //!< reference to the node C
   QuadtreeNode*                   nodeD;              //!< reference to the node D

};

#endif /* _QUADTREE_NODE_H */
