/*!
    \file proto_class.h
    \brief Definition of ...

*/

#ifndef _QUADTREE_NODE_H
#define _QUADTREE_NODE_H

#include "base_object.h"
#include "vector.h"

// FORWARD DEFINITION
class QuadtreeNode;

//! A class for a Quadtree Node representation
class QuadtreeNode : public BaseObject {

 public:
  QuadtreeNode();
  virtual ~QuadtreeNode();

  void separateNode();

  void drawTree(int depth, int drawMode) const;


 private:
   Vector                          center;             //!< center coordinate of the quadtree node - relative coordinates in model space(!)
   float                           axisLength;         //!< axis length of the quadtree
   float                           maxHeigth;          //!< max height of the model in the quadtree

   sTriangleExt*                   triangles;
   unsigned int                    numTriangles;

   QuadtreeNode*                   nodeA;              //!< reference to the node A
   QuadtreeNode*                   nodeB;              //!< reference to the node B
   QuadtreeNode*                   nodeC;              //!< reference to the node C
   QuadtreeNode*                   nodeD;              //!< reference to the node D

};

#endif /* _QUADTREE_NODE_H */
