/*!
    \file ini_parser.h
    \brief A small ini file parser

    Can be used to find a defined [Section] in an ini file and get the VarName=Value entries
*/

#ifndef _INI_PARSER_H
#define _INI_PARSER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "base_object.h"

#define PARSELINELENGHT     512       //!< how many chars to read at once

//! ini-file parser
/**
        This class can be used to load an initializer file and parse it's contents for variablename=value pairs.
*/
class IniParser : public BaseObject
{
 public:
  IniParser (const char* filename);
  ~IniParser ();

  const char* getVar(const char* name, const char* section, const char* defvalue);
  int openFile(const char* name);
  int getSection( const char* section);
  int nextVar( const char* name, const char* value);

 private:
  FILE*         stream;                       //!< A FileStream to be loaded
  bool          bInSection;                   //!< if the requested parameter is in the section.
  char          internbuf[PARSELINELENGHT];   //!< a buffer


};

#endif /* _INI_PARSER_H */
