/*!
    \file class_list.h
    \brief Definition of the Class List, that handles a Class-Specific-Control structure

 */

#ifndef _CLASS_LIST_H
#define _CLASS_LIST_H

#include "class_id.h"

// FORWARD DEFINITION
class BaseObject;
template<class T> class tList;


//! A class that handles Pointers to Objects of all type.
/**
  here all the Pointers to all the Object of orxonox are stored, that implement BaseObject
  for now, this is only for debugging reasons, and we should be able to detect undeleted
  Objects.
 */
class ClassList {

  public:
    ClassList(const long& classID, const char* className);
    virtual ~ClassList();

    static void addToClassList(BaseObject* objectPointer, const long& classID, const char* className);
    static void removeFromClassList(BaseObject* objectPointer);

    static void debug();

  private:
    //! a Struct for Lists of Objects
    struct ObjectList
    {
      BaseObject*            pointerToObject;
      ObjectList*            next;
    };

    long                     classID;
    const char*              className;

    ClassList*               next;

    unsigned int             objectCount;


    static ClassList*        first;
    static unsigned int      classCount;

};

#endif /* _CLASS_LIST_H */
