/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "class_list.h"
#include "base_object.h"

#include "compiler.h"
#include "debug.h"

using namespace std;


/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
ClassList::ClassList(const long& classID, const char* className)
{
  this->objectCount = 0;
  this->next = NULL;
  this->className = className;
  this->classID = classID;
}


/**
   \brief standard deconstructor

*/
ClassList::~ClassList ()
{
  // delete what has to be deleted here
}

ClassList*  ClassList::first = NULL;
unsigned int ClassList::classCount = 0;



void ClassList::addToClassList(BaseObject* objectPointer, const long& classID, const char* className)
{
  ClassList* regClass;

  if(ClassList::first == NULL)
    ClassList::first = regClass = new ClassList(classID, className);
  else
  {
    ClassList* tmp = ClassList::first;
    while (likely(tmp != NULL))
    {
      if (tmp->classID == classID)
      {
        regClass = tmp;
        break;
      }

      if (tmp->next == NULL)
        tmp->next = regClass = new ClassList(classID, className);
      tmp = tmp->next;
    }
  }

  ++regClass->objectCount;
}

void ClassList::removeFromClassList(BaseObject* objectPointer)
{
  ClassList* tmp = ClassList::first;
  while (likely(tmp != NULL))
  {
    if (objectPointer->isA(tmp->classID))
    {
      --tmp->objectCount;
    }

    tmp = tmp->next;
  }
}


void ClassList::debug()
{
  PRINT(0)("=================\n");
  PRINT(0)("=  CLASS_LIST   =\n");
  PRINT(0)("=================\n");
  ClassList* tmp = ClassList::first;
  while (likely(tmp != NULL))
  {
    PRINT(0)("CLASS %s has %d instances\n", tmp->className, tmp->objectCount);

    tmp = tmp->next;
  }
  PRINT(0)("==============CL=\n");

}
