/*!
    \file physics_engine.h
    \brief Definition of the PhysicsEngine-singleton Class

*/

#ifndef _PHYSICS_ENGINE_H
#define _PHYSICS_ENGINE_H

#include "base_object.h"

#include "physics_connection.h"
#include "physics_interface.h"
#include "field.h"

// Forward Declaration
template<class T> class tList;
class TiXmlElement;

//! A class, that brings things into motion through Physics.
class PhysicsEngine : public BaseObject {

 public:
  virtual ~PhysicsEngine(void);
  /** \returns a Pointer to the only object of this Class */
  inline static PhysicsEngine* getInstance(void) { if (!singletonRef) singletonRef = new PhysicsEngine();  return singletonRef; };

  void loadParams(const TiXmlElement* root);

  void                   addPhysicsInterface(PhysicsInterface* physicsInterface);
  void                   removePhysicsInterface(PhysicsInterface* physicsInterface);
  PhysicsInterface*      getPhysicsInterfaceByName(const char* physicsInterfaceName) const;

  void                   addField(Field* field);
  void                   removeField(Field* field);
  Field*                 getFieldByName(const char* FieldName) const;

  void                   addConnection(PhysicsConnection* connection);
  void                   removeConnection(PhysicsConnection* connection);
  PhysicsConnection*     getPhysicsConnectionByName(const char* physicsConnectionName) const;


  void                   tick(float dt);

  void                   debug(void) const;

 private:
  PhysicsEngine(void);

 private:
  static PhysicsEngine*         singletonRef;         //!< the singleton reference of the PhysicsEngine

  tList<PhysicsInterface>*      interfaces;           //!< a list of physically based objects
  tList<Field>*                 fields;               //!< a list of physicsl fields.
  tList<PhysicsConnection>*     connections;          //!< a list of physical connections
};



#endif /* _PHYSICS_ENGINE_H */
