/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "gravity.h"

#include "load_param.h"
#include "factory.h"

using namespace std;

CREATE_FACTORY(Gravity);

/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
Gravity::Gravity ()
{
   this->setClassName("Gravity");
}

Gravity::Gravity(const TiXmlElement* root)
{
  this->setClassName("Gravity");

  this->loadParams(root);
}

/**
   \brief standard deconstructor

*/
Gravity::~Gravity ()
{
  // delete what has to be deleted here
}

void Gravity::loadParams(const TiXmlElement* root)
{
  static_cast<Field*>(this)->loadParams(root);

}

/**
   \brief calculates the Gravity on any point in space
   \param data The Position of the Point in space to attache gravity to.
   \returns The force.
*/
Vector Gravity::calcForce(const Vector& data) const
{
  return Vector(0,-1,0) * this->getMagnitude();
}


