/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*!
    \file field.h
    \brief abstract definition of a Physical Field

    This is a totally abstract class, that only enables different Physical Fields to
    exist on a common Level.
*/

#ifndef _FIELD_H
#define _FIELD_H

#include "p_node.h"

// FORWARD DEFINITION
class TiXmlElement;


//! An abstract class that represents a Force.
class Field : public PNode
{
 public:
  Field();
  Field(const TiXmlElement* root);
  virtual ~Field();

  void init(void);
  void loadParams(const TiXmlElement* root);

  /**
      \param data This is the data given to this force, to calculate the ForceVector
      \returns The Force Vector
  */
  virtual Vector calcForce(const Vector& data) const = 0;

  void setMagnitude(float magnitude);
  /** \returns The Magnitude of the Field */
  inline const float& getMagnitude(void) const {return this->magnitude;}

  void setAttenuation(float attenuation);
  /** \returns The Attenuation of the Fiels */
  inline const float& getAttenuation(void) const {return this->attenuation;}

 private:
  float magnitude;                //!< The strength of the field
  float attenuation;              //!< The Attenuation (the bigger the shorter the influenced distance).
};

#endif /* _FIELD_H */
