/*!
    \file bv_tree.h
    \brief Definition of a bounding volume tree

 */

#ifndef _OBB_TREE_NODE_H
#define _OBB_TREE_NODE_H

#include "bv_tree_node.h"



// FORWARD DEFINITION
class BoundingVolume;
class OBB;
class OBBTree;
class Plane;
class PNode;
//struct sVec3D;

//! A class that represents a bounding volume tree
class OBBTreeNode : public BVTreeNode {


  public:
    OBBTreeNode();
    virtual ~OBBTreeNode();

    virtual void spawnBVTree(const int depth, sVec3D *verticesList, const int length);

    BoundingVolume* getBV(int index) const { return (BoundingVolume*)this->bvElement; }
    inline const int getIndex() { return this->treeIndex; }
    inline void setTreeRef(OBBTree* tree) { this->obbTree = tree;}

    virtual void collideWith(BVTreeNode* treeNode, PNode* nodeA, PNode* nodeB);

    virtual void drawBV(int depth, int drawMode);

    void debug(void) const;

  private:
    void calculateBoxCovariance(OBB* box, sVec3D* verticesList, int length);
    void calculateBoxEigenvectors(OBB* box, sVec3D* verticesList, int length);
    void calculateBoxAxis(OBB* box, sVec3D* verticesList, int length);
    void forkBox(OBB* box);

    bool overlapTest(OBB* boxA, OBB* boxB, PNode* nodeA, PNode* nodeB);

  protected:
    OBB*                bvElement;                  //!< the obb element
    OBBTreeNode*        nodeLeft;                   //!< ref to the left tree node
    OBBTreeNode*        nodeRight;                  //!< ref to the right tree node

  private:
    unsigned int        treeIndex;                  //!< Index number of the BV in the tree
    sVec3D*             vertices;                   //!< pointer to the vertices data
    int                 numOfVertices;              //!< number of vertices in vertices data
    int                 depth;                      //!< the depth of the node in the tree
    static OBBTree*     obbTree;                    //!< reference to the obb tree
    Plane*              separationPlane;            //!< the separation plane of the obb
    sVec3D*             sepPlaneCenter;             //!< only needed to draw plane \todo: separationPlane drawing
    int                 longestAxisIndex;           //!< only needed to draw plane

    /* tmp saving place for obb variables */
    sVec3D*             tmpVert1;                   //!< pointer to the vert data of obbox1
    sVec3D*             tmpVert2;                   //!< pointer to the vert data of obbox1
    int                 tmpLen1;                    //!< len vert data obbox1
    int                 tmpLen2;                    //!< len vert data obbox2

    static float**       coMat;                     //!< temp covariance matrice save place - consumes less mem
    static float**       eigvMat;                   //!< temp eigenvector matrice save place
    static float*        eigvlMat;                  //!< temp eigenvalue vector save place
    static int*          rotCount;                  //!< temp rotations count save place: how many givens-rotations where needed to transform the matrix :)

    GLUquadricObj*    sphereObj;
};

#endif /* _OBB_TREE_NODE_H */
