/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION

#include "obb_tree.h"
#include "obb_tree_node.h"
#include "obb.h"
#include "debug.h"
#include "compiler.h"
#include "material.h"
#include "p_node.h"

using namespace std;


/**
   \brief standard constructor
*/
OBBTree::OBBTree ()
{
  this->init();
}

OBBTree::OBBTree(int depth, sVec3D *verticesList, const int length)
{
  this->init();
  this->spawnBVTree(depth, verticesList, length);
}



void OBBTree::init()
{
  this->setClassID(CL_OBB_TREE, "OBBTree");

  material = new Material*[5];
  for(int i = 0; i < 5; ++i)
  {
    material[i] = new Material();
    material[i]->setIllum(3);
  }
  material[0]->setAmbient(0.0, 0.3, 0.0);
  material[1]->setAmbient(0.4, 0.0, 0.2);
  material[2]->setAmbient(1.0, 0.0, 0.0);
  material[3]->setAmbient(5.0, 3.0, 1.0);
  material[4]->setAmbient(1.0, 0.0, 7.0);


  transparentMaterial = new Material*[5];
  for(int i = 0; i < 5; ++i)
  {
    transparentMaterial[i] = new Material();
    transparentMaterial[i]->setIllum(3);
    transparentMaterial[i]->setTransparency(0.2);
  }
  transparentMaterial[0]->setAmbient(0.0, 0.3, 0.0);
  transparentMaterial[1]->setAmbient(0.4, 0.0, 0.2);
  transparentMaterial[2]->setAmbient(1.0, 0.0, 0.0);
  transparentMaterial[3]->setAmbient(5.0, 3.0, 1.0);
  transparentMaterial[4]->setAmbient(1.0, 0.0, 7.0);

  this->collisionMaterial = new Material();
  this->collisionMaterial->setIllum(5);
  this->collisionMaterial->setTransparency(0.5);
  this->collisionMaterial->setAmbient(1.0, 1.0, 1.0);

  this->id = 0;
}

/**
   \brief standard deconstructor

*/
OBBTree::~OBBTree ()
{
  // delete what has to be deleted here
}


void OBBTree::spawnBVTree(int depth, sVec3D *verticesList, const int length)
{
  if( unlikely(this->rootNode != NULL))
    {
      PRINTF(2)("The BVTree has already been spawned, flushing and respawning again...\n");
      this->flushTree();
    }
  OBBTreeNode* node = new OBBTreeNode();
  this->rootNode = node;
  this->rootNode->setTreeRef(this);
  this->rootNode->spawnBVTree(--depth, verticesList, length);
}


void OBBTree:: flushTree()
{}


void OBBTree::collideWith(BVTree* tree, PNode* nodeA, PNode* nodeB)
{
  this->rootNode->collideWith(((OBBTree*)tree)->getRootNode(), nodeA, nodeB);
}


void OBBTree::drawBV(int depth, int drawMode) const
{
  if( likely(this->rootNode != NULL))
  {
    this->rootNode->drawBV(depth, drawMode);
  }
}



void OBBTree::debug()
{
  PRINT(0)("\n==============================| OBBTree::debug() |===\n");
  PRINT(0)("=  Spawning Tree: Start\n");

  /* generate some test vertices */
  int const length = 9;
  sVec3D* vertList = new sVec3D[length];
//   sVec3D data[length]  = {{0.0, 0.0, 0.0},{1.0, 2.0, 5.0},{0.0, 6.0, 9.0},
//                           {1.0, 4.0, 12.0}, {1.0, 2.0, 16.0}, {0.0, 0.0, 19.0},
//                           {0.0, 3.0, 23.0}, {1.0, 5.0, 30.0}, {0.0, 10.0, 35.0}};

  sVec3D data[length]  = {{0.0, 0.0, 0.0},{1.0, 2.0, 5.0},{1.0, 5.0, 30.0},
                          {0.0, 3.0, 23.0}, {0.0, 6.0, 9.0}, {0.0, 10.0, 35.0},
                          {1.0, 4.0, 12.0}, {1.0, 2.0, 16.0}, {0.0, 0.0, 19.0}};

  for(int i = 0; i < length; ++i)
    {
      vertList[i][0] = data[i][0];
      vertList[i][1] = data[i][1];
      vertList[i][2] = data[i][2];
    }

  this->spawnBVTree(3, vertList, length);

  PRINT(0)("=  Spawning Tree: Finished\n");
  PRINT(0)("=======================================================\n");

}
