/*!
    \file obb.h
    \brief Definition of an OBB (object Oriented Bounding Box)

*/

#ifndef _OBB_H
#define _OBB_H

#include "base_object.h"
#include "bounding_volume.h"

template<class T> class tList;

//! A class representing an extended bounding volume tree: an obb tree
class OBB : public BoundingVolume {

 public:
  OBB();
  virtual ~OBB();


  inline Vector* getAxis () const { return this->axis; }
  inline const float* getHalfLength() const { return this->halfLength; }

  virtual void mergeWith(const BoundingVolume &bv);

  virtual void drawBV(int currentDepth, int drawMode) const;



 public:
  Vector*          axis;                       //!< Axes of oriented box [x,y,z]
  float*           halfLength;                 //!< Half lengths of the box along the axis
  float            covarianceMatrix[3][3];     //!< the covariance matrix

  bool                bCollided;                  //!< is true if this obb has collided

};

#endif /* _OBB_H */
