/*!
    \file bv_tree.h
    \brief Definition of a bounding volume tree

*/

#ifndef _BV_TREE_NODE_H
#define _BV_TREE_NODE_H

#include "base_object.h"
#include "abstract_model.h"

// FORWARD DEFINITION
class BoundingVolume;
class BVTree;
class PNode;
template<class T> class tList;

//! A class that represents a bounding volume tree
class BVTreeNode : public BaseObject {

 public:
  BVTreeNode();
  virtual ~BVTreeNode();

  virtual void spawnBVTree(const int depth, sVec3D *verticesList, const int length ) = NULL;

  virtual BoundingVolume* getBV(int index) const = NULL;
  inline const int getIndex() { return this->treeIndex; }

  virtual void collideWith(BVTreeNode* treeNode, PNode* nodeA, PNode* nodeB) = NULL;

  virtual void drawBV(int depth, int drawMode) = NULL;


 private:
  unsigned int        treeIndex;                  //!< Index number of the BV in the tree

};

#endif /* _BV_TREE_NODE_H */
