/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   this file extends the framework file, so it renders what i want.
*/

#include "framework.h"

#include "fields.h"
#include "stdlibincl.h"
#include "light.h"

#include "cd_engine.h"
#include "bv_tree.h"

#include "md2Model.h"
#include "model.h"
#include "test_entity.h"
#include "environment.h"

#include "graphics_engine.h"
#include "list.h"


Model* mod;
MD2Model* model;
int drawMode;
int depth;
tList<WorldEntity>* entityList;

int lastFrame, currentFrame, dt;
bool drawModel;

void Framework::moduleInit(int argc, char** argv)
{
  GraphicsEngine::getInstance()->setWindowName("Collision Cluster", "collision");

  CDEngine::getInstance();

  /* Simple Test */
  //CDEngine::getInstance()->debug();

  /* MD2 Model Test */
//   model = new MD2Model("models/tris.md2", "models/tris.pcx");
//   model->tick(0.1f);
//   CDEngine::getInstance()->debugSpawnTree(9, model->data->pVertices, model->data->numVertices);

  /* OBJ - Model Test */
//   mod = (Model*)ResourceManager::getInstance()->load("models/reaplow.obj", OBJ, RP_CAMPAIGN);
//   CDEngine::getInstance()->debugSpawnTree(9, (sVec3D*)mod->getVertexArray(), mod->getVertexArrayCount());



  entityList = new tList<WorldEntity>();

  TestEntity* a = new TestEntity(); a->setName("Clown1");
  Environment* b = new Environment(); b->setName("Jaeger");
  b->setRelCoor(0.0, 0.0, -10.0);

//   TestEntity* c = new TestEntity(); c->setName("Colwn2");
//   c->setRelCoor(0.0, 0.0, -20.0);

  entityList->add(a);
  entityList->add(b);
//   entityList->add(c);

  CDEngine::getInstance()->setEntityList(entityList);

  LightManager* lightMan = LightManager::getInstance();
  lightMan->setAmbientColor(.1,.1,.1);
  lightMan->addLight();
  lightMan->setPosition(30, 30, 30);
  lightMan->addLight();
  lightMan->setPosition(-30, -30, -30);

  /* properties */
  drawMode = DRAW_MODEL;
  depth = 0;
  dt = lastFrame = currentFrame = 0;


  moduleHelp();
}


void Framework::moduleEventHandler(SDL_Event* event)
{
  switch (event->type)
  {
    case SDL_KEYDOWN:
      switch (event->key.keysym.sym)
      {
        case SDLK_a:
          drawMode |= DRAW_ALL;
          break;
        case SDLK_0:
        {
          printf("Setting tree depth = 0\n");
          depth = 0;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_1:
        {
          printf("Setting tree depth = 1\n");
          depth = 1;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_2:
        {
          printf("Setting tree depth = 2\n");
          depth = 2;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_3:
        {
          printf("Setting tree depth = 3\n");
          depth = 3;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_4:
        {
          printf("Setting tree depth = 4\n");
          depth = 4;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_5:
        {
          printf("Setting tree depth = 5\n");
          depth = 5;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_6:
        {
          printf("Setting tree depth = 6\n");
          depth = 6;
          int temp = drawMode & DRAW_ALL;
          drawMode ^= temp;
          drawMode |= DRAW_SINGLE;
          break;
        }
        case SDLK_s:
          if(drawMode & DRAW_SEPARATING_PLANE)
          {
            int temp = drawMode & DRAW_SEPARATING_PLANE;
            drawMode ^= temp;
            printf("Removing Separation Plane\n");
          }
          else
          {
            drawMode |= DRAW_SEPARATING_PLANE;
            printf("Drawing Separation Plane\n");
          }

          break;
        case SDLK_p:
          if(drawMode & DRAW_BV_POLYGON)
          {
            int temp = drawMode & DRAW_BV_POLYGON;
            drawMode ^= temp;
            printf("Removing OBB Polygons\n");
          }
          else
          {
            drawMode |= DRAW_BV_POLYGON;
            printf("Drawing OBB Polygons\n");
          }
          break;

      }
  }
}


void Framework::moduleTick(float dt)
{

  //CDEngine::getInstance()->checkCollisions();

  currentFrame = SDL_GetTicks();
  dt = currentFrame - lastFrame;

  if( dt > 0)
  {
    float fps = 1000/dt;

          // temporary, only for showing how fast the text-engine is
    printf("we got %f fps\n", fps);
  }
  else
  {
          /* the frame-rate is limited to 100 frames per second, all other things are for nothing.
          */
    SDL_Delay(1);
    dt = 10;
  }


  tIterator<WorldEntity>* iterator = entityList->getIterator(); /* get the iterator - JAVA style */
  WorldEntity* entity = iterator->nextElement();   /* this returns the FIRST element */
  while( entity != NULL)                        /* nextElement() will return NULL at the end */
  {
    entity->tick(0.1);
    entity = iterator->nextElement();       /* give back the next element or NULL if last */
  }
  delete iterator;

  lastFrame = currentFrame;
}


void Framework::moduleDraw() const
{
  CDEngine::getInstance()->drawBV(depth, drawMode);
  LightManager::getInstance()->draw();

  tIterator<WorldEntity>* iterator = entityList->getIterator(); /* get the iterator - JAVA style */
  WorldEntity* entity = iterator->nextElement();   /* this returns the FIRST element */
  while( entity != NULL)                        /* nextElement() will return NULL at the end */
  {
    if( drawModel)
    entity->draw();
    entity->drawBVTree(depth, drawMode);
    entity = iterator->nextElement();       /* give back the next element or NULL if last */
  }
  delete iterator;
  //model->draw();
}


void Framework::moduleHelp(void) const
{
  printf("\n\n===========================");
  printf("Collision Detection Modler:\n");
  printf("Key Bindings:\n");
  printf(" -| Displaying Polygons\t\t p\n");
  printf(" -| Displaying Separation Plane\t s\n");
  printf("\n");
  printf(" -| Tree Depth 0\t\t 0\n");
  printf(" -| Tree Depth 1\t\t 1\n");
  printf(" -| Tree Depth 2\t\t 2\n");
  printf(" -| Tree Depth 3\t\t 3\n");
  printf(" -| Tree Depth 4\t\t 4\n");
  printf(" -| Tree Depth 5\t\t 5\n");
  printf("===========================\n\n");

}

int boxPolygons(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_BV_POLYGON)
  {
    int temp = drawMode & DRAW_BV_POLYGON;
    drawMode ^= temp;
    printf("Removing OBB Polygons\n");
  }
  else
  {
    drawMode |= DRAW_BV_POLYGON;
    printf("Drawing OBB Polygons\n");
  }
}

int seperatingPlanes(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_SEPARATING_PLANE)
  {
    int temp = drawMode & DRAW_SEPARATING_PLANE;
    drawMode ^= temp;
    printf("Removing Separation Plane\n");
  }
  else
  {
    drawMode |= DRAW_SEPARATING_PLANE;
    printf("Drawing Separation Plane\n");
  }
}


int blendedBox(GtkWidget* nonInterest, void* widget)
{
  if(drawMode & DRAW_BV_BLENDED)
  {
    int temp = drawMode & DRAW_BV_BLENDED;
    drawMode ^= temp;
    printf("Removing OBB Polygons\n");
  }
  else
  {
    drawMode |= DRAW_BV_BLENDED;
    printf("Drawing OBB Polygons\n");
  }
}


int drawModels(GtkWidget* nonInterest, void* widget)
{
  drawModel = !drawModel;
}


int treeDepth(GtkWidget* nonInterest, void* widget)
{
  Option* option = (Option*) widget;
  const char* name = option->getTitle();
  char* value = option->save();

  depth = atoi(value);
  printf("Setting tree depth = %i\n", depth);
  int temp = drawMode & DRAW_ALL;
  drawMode ^= temp;
  drawMode |= DRAW_SINGLE;

  delete value;
}


void Framework::moduleInitGui(int argc, char** argv)
{
  Window* guiMainWindow = NULL;

  initGUI(0, NULL);

  guiMainWindow = new Window("Collision_detection");
  {
    Box* windowBox = new Box('v');
    {
      CheckButton* BoxPolygons = new CheckButton("Draw OBB Polygons");
      BoxPolygons->connectSignal("clicked", (void*)BoxPolygons, boxPolygons);
      windowBox->fill(BoxPolygons);


      CheckButton* BlendedBox = new CheckButton("Draw OBB Blended");
      BlendedBox->connectSignal("clicked", (void*)BlendedBox, blendedBox);
      windowBox->fill(BlendedBox);


      CheckButton* DrawModels = new CheckButton("Draw Models");
      DrawModels->connectSignal("clicked", (void*)DrawModels, drawModels);
      windowBox->fill(DrawModels);


      CheckButton* SeperatingPlanes = new CheckButton("SeperatingPlanes");
      SeperatingPlanes->connectSignal("clicked", (void*)SeperatingPlanes, seperatingPlanes);
      windowBox->fill(SeperatingPlanes);


      Slider* TreeDepth = new Slider("TreeDepth", 0, 5);
      TreeDepth->connectSignal("value_changed", (void*)TreeDepth, treeDepth);
      windowBox->fill(TreeDepth);
    }
    guiMainWindow->fill(windowBox);
  }
  Window::mainWindow->showall();
  Window::mainWindow->setSize(300, 500);
}
