/*!
    \file obb_tree.h
    \brief Definition of an obb tree (object oriented Bounding Box)

*/

#ifndef _OBB_TREE_H
#define _OBB_TREE_H

#include "bv_tree.h"
#include "abstract_model.h"
#include "material.h"

class Material;
class OBBTreeNode;

//! A class for representing an obb tree
class OBBTree : public BVTree {

  public:
    OBBTree();
    OBBTree(int depth, sVec3D *verticesList, const int length);
    virtual ~OBBTree();
    void init();

    virtual void spawnBVTree(int depth, sVec3D *verticesList, const int length);
    virtual void flushTree();

    virtual void collideWith(BVTree* tree);

    virtual void drawBV(int depth, int drawMode) const;

    Material* getMaterial(unsigned int depth) { return material[depth%5]; }
    Material* getTransparentMaterial(unsigned int depth) { return transparentMaterial[depth%5]; }
    int getID() { return ++this->id;}


    void debug();

  public:



  private:
    OBBTreeNode*         rootNode;                        //!< reference to the root node of the tree
    Material**           material;
    Material**           transparentMaterial;
    int                  id;
};

#endif /* _OBB_TREE_H */
