/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION

#include "cd_engine.h"
#include "obb_tree.h"
#include "debug.h"
#include "abstract_model.h"
#include "world_entity.h"
#include "list.h"

using namespace std;


/**
   \brief standard constructor
*/
CDEngine::CDEngine ()
{
   this->setClassName("CDEngine");
   this->setClassID(CL_CD_ENGINE, "CDEngine");

   /* testing purposes only: */
   //this->rootTree = new OBBTree();
}

/**
   \brief the singleton reference to this class
*/
CDEngine* CDEngine::singletonRef = NULL;

/**
   \brief standard deconstructor

*/
CDEngine::~CDEngine ()
{
  CDEngine::singletonRef = NULL;

}


/**
  \brief this is the collision checking function

  there are some speed improvements that can be done here. a rewrite of the list a would be appropriate to
  be able to enhance iteration speed.
 */
void CDEngine::checkCollisions()
{
  tIterator<WorldEntity>* iterator1 = entityList->getIterator();
  tIterator<WorldEntity>* iterator2 = entityList->getIterator();
  WorldEntity* entity1 = iterator1->nextElement();
  WorldEntity* entity2 = iterator2->seekElement(entity1);
  printf("checking for collisions\n");
  while( entity1 != NULL)
  {
    printf("entering l1\n");
    while( entity2 != NULL)
    {
      printf("entering l2 - checking object %s against %s\n", entity1->getName(), entity2->getName());
      entity1->collideWith(entity2);
      entity2 = iterator2->nextElement();

    }
    entity1 = iterator1->nextElement();
    entity2 = iterator2->seekElement(entity1);

  }
  delete iterator1;
  delete iterator2;
}



void CDEngine::checkCollisionObjects()
{}


void CDEngine::checkCollisionGround()
{}


void CDEngine::drawBV(int depth, int drawMode) const
{
  /* this would operate on  worldList bases, for testing purposes, we only use one OBBTree */
  //this->rootTree->drawBV(depth, drawMode);

  tIterator<WorldEntity>* iterator = entityList->getIterator();
  WorldEntity* entity = iterator->nextElement();
  while( entity != NULL)
  {
    entity->drawBVTree(depth, drawMode);
    entity = iterator->nextElement();
  }
  delete iterator;
  //model->draw();
}





void CDEngine::debug()
{
  PRINT(0)("\n=============================| CDEngine::debug() |===\n");
  PRINT(0)("=  CDEngine: Spawning Tree Start\n");
  //this->rootTree->debug();
  PRINT(0)("=  CDEngine: Spawning Tree: Finished\n");
  PRINT(0)("=======================================================\n");

}

void CDEngine::debugSpawnTree(int depth, sVec3D* vertices, int numVertices)
{
  if ( this->rootTree == NULL)
    this->rootTree = new OBBTree();
  this->rootTree->spawnBVTree(depth, vertices, numVertices);
}
