-- Get objects from orxonox
thisscript:addObject("SpaceShip", "Player")
thisscript:addObject("CameraMan", "cameraManager")
thisscript:addObject("NPC", "Ragnar01")
thisscript:addObject("NPC", "Pirate01")
thisscript:addObject("NPC", "Pirate02")
thisscript:addObject("NPC", "Pirate03")
thisscript:addObject("NPC", "Pirate04")
thisscript:addObject("NPC", "Pirate05")
thisscript:addObject("NPC", "Pirate06")
thisscript:addObject("NPC", "Pirate07")
-- thisscript:addObject("NPC", "Pirate08")
-- thisscript:addObjectAsName("GameWorld", "Mission 1", "gameWorld")

triggerInit = ScriptTrigger()
triggerInit:setScript("vs1.lua")
triggerInit:setFunction("init")
triggerInit:setActiveOnCreation(true)

-- Create the cutscene trigger
triggerCutscene = ScriptTrigger()
triggerCutscene:setScript("vs1.lua")
triggerCutscene:setFunction("startSequence")
triggerCutscene:setRadius(50)
triggerCutscene:setTarget("Player")
triggerCutscene:setAbsCoor(2300 , 0 , 10)
triggerCutscene:setDebugDraw(true)
triggerCutscene:setActiveOnCreation(false)

-- Create another cutscene trigger
triggerCutscene02 = ScriptTrigger()
triggerCutscene02:setScript("vs1.lua")
triggerCutscene02:setFunction("switchToOtherPirate")
triggerCutscene02:setActiveOnCreation(true)

-- Create the cool Ragnar trigger
triggerRagnar = ScriptTrigger()
triggerRagnar:setScript("vs1.lua")
triggerRagnar:setFunction("startRagnar")
triggerRagnar:setRadius(50)
triggerRagnar:setTarget("Player")
triggerRagnar:setAbsCoor(3600 , 0 , 0)
triggerRagnar:setDebugDraw(true)
triggerRagnar:setActiveOnCreation(false)

-- Create a great AI activater
triggerAI01 = ScriptTrigger()
triggerAI01:setScript("vs1.lua")
triggerAI01:setFunction("activateGroup1")
triggerAI01:setRadius(50)
triggerAI01:setTarget("Player")
triggerAI01:setAbsCoor(2600, 0, 15)
triggerAI01:setDebugDraw(true)
triggerAI01:setActiveOnCreation(false)

-- Create another great AI activater
triggerAI02 = ScriptTrigger()
triggerAI02:setScript("vs1.lua")
triggerAI02:setFunction("activateGroup2")
triggerAI02:setRadius(50)
triggerAI02:setTarget("Player")
triggerAI02:setAbsCoor(4900, 0, 50)
triggerAI02:setDebugDraw(true)
triggerAI02:setActiveOnCreation(false)

-- Global Variables
counter = 0
cutsceneRunning = false
cutsceneEnd = false

function init(timestep)
-- cameraManager:setCam("GameWorld-Camera")
cameraManager:atachCameraToWorldEntity("CameraOne", "NPC", "Pirate01")
cameraManager:setRelCoor("CameraOne", 8, 4 , 3.3)

Ragnar01:pause(true)
-- cameraManager:changeTarget("CameraOne", "NPC", "Pirate01")
-- cameraManager:jumpCam("CameraOne", 3300, 0, 50)

return true
end

function startSequence(timestep)

cameraManager:setCam("CameraOne")
-- gameWorld:showText("Kill those traitorous bastards")
-- cameraManager:changeCurrTarget("NPC", "Pirate01")
-- cameraManager:atachCurrCameraToWorldEntity("NPC", "Pirate01")
cutsceneRunning = true
return true
end

function switchToOtherPirate(timestep)

if cutsceneRunning then
counter = counter + timestep
end

if counter > 5 and counter < 6 then
cameraManager:atachCameraToWorldEntity("CameraOne", "NPC", "Pirate03")
cameraManager:setRelCoorSoft("CameraOne", 8, 4 , 3.3, 5)
end

if counter > 14 then
cutsceneEnd = true
cameraManager:setCam("GameWorld-Camera")
end


return cutsceneEnd
end


function startRagnar(timestep)

Ragnar01:pause(false)
return true
end

function activateGroup1(timestep)

Pirate01:setAI(true)
Pirate02:setAI(true)
Pirate03:setAI(true)

return true
end

function activateGroup2(timestep)

Pirate04:setAI(true)
Pirate05:setAI(true)
Pirate06:setAI(true)

return true
end

