#ifndef _FRAMEWORK_H
#define _FRAMEWORK_H

#include "vector.h"
#include "glincl.h"
#include "SDL_events.h"
#include "debug.h"
#include "graphics_engine.h"

#ifdef GUI_MODULE
#include "gui_gtk.h"
#endif

#define MOUSE_BUTTON_COUNT 3

class Camera;

class Framework {
  public:
    ~Framework();

    /** \returns a Pointer to the only object of this Class */
    inline static    Framework* getInstance(void) { if (!singletonRef) singletonRef = new Framework();  return singletonRef; };

  public:
    void             moduleInit(int argc, char** argv);
#ifdef GUI_MODULE
    void             moduleInitGui(int argc, char** argv);
#endif
    void             moduleEventHandler(SDL_Event* event);
  void               moduleTick(float dt);
  void               moduleDraw(void) const;

  void               moduleHelp(void) const;


  void               init(void);
  static void*       mainLoop(void* tmp);
  bool               draw(float dt);
  float              tick();
  bool               eventHandler();
  void               quit();

  static void*       mainloopGui(void* tmp);

  void               printHelp(void) const;


  private:
    Framework();

  private:
    static Framework*           singletonRef;

    Camera*                     camera;

    bool                        isFinished;

    int                         movement [4];
    float                       backgroundColor[4];

    Uint32                      lastFrame;
    Uint32                      currFrame;

    Uint8*                      keys;        // This variable will be used in the keyboard routine
    bool                        mouseDown[MOUSE_BUTTON_COUNT];

};

#ifdef GUI_MODULE
int quitGui(GtkWidget* widget, void* data);
#endif

#endif /* _FRAMEWORK_H */
