/*!
    \file skybox.h
    \brief Definition of the SkyBox, that handles the Display of an atmosphere for orxonox.

    A SkyBox is always centered at the current working Camera, and will only obey the cameras
    movment but not its rotation.
*/

#ifndef _SKYBOX_H
#define _SKYBOX_H

/* INCLUDES */
#include "world_entity.h"

/* FORWARD DEFINITION */
class Material;
class Vector;

//! A Class to handle a SkyBox
class SkyBox : public WorldEntity
{
 public:
  SkyBox(const char* fileName = NULL);
  SkyBox(const TiXmlElement* root);

  virtual ~SkyBox();

  void loadParams(const TiXmlElement* root);

  void preInit(void);
  void postInit(void);


  void setSize(float size);
  /** \brief assumes jpg as input-format */
  void setTexture(const char* name) { setTextureAndType (name, "jpg"); };
  void setTextureAndType(const char* name, const char* extension);
  void setTextures(const char* top, const char* bottom, const char* left, const char* right, const char* front, const char* back);

  virtual void draw();

 private:
  void rebuild();

  Model*          skyModel;        //!< A Model for the Sky. This must not be the same as the Model from WorldEntity, because it is not alocated through the ResourceManager.
  Material**      material;        //!< Materials for the SkyBox. sorted by number (0-5) top, bottom, left, right, front, back
  float           size;            //!< Size of the SkyBox. This should match the frustum maximum range.

};

#endif  /* _SKYBOX_H */



