/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_COLLISION

#include "obb_tree.h"
#include "obb_tree_node.h"
#include "obb.h"
#include "debug.h"
#include "compiler.h"

using namespace std;


/**
   \brief standard constructor
*/
OBBTree::OBBTree ()
{
   this->setClassID(CL_OBB_TREE, "OBBTree");

}


/**
   \brief standard deconstructor

*/
OBBTree::~OBBTree ()
{
  // delete what has to be deleted here
}


void OBBTree::spawnBVTree(int depth, sVec3D *verticesList, const int length)
{
  if( unlikely(this->rootNode != NULL))
    {
      PRINTF(2)("The BVTree has already been spawned, flushing and respawning again...\n");
      this->flushTree();
    }
  OBBTreeNode* node = new OBBTreeNode();
  this->rootNode = node;
  this->rootNode->spawnBVTree(depth, verticesList, length);
}


void OBBTree:: flushTree()
{}


void OBBTree::collideWith(const OBBTree &tree)
{}


void OBBTree::drawBV(int currentDepth, const int depth) const
{
  if( likely(this->rootNode != NULL))
  {
    this->rootNode->drawBV(currentDepth, depth);
    this->rootNode->drawBVPolygon(currentDepth, depth);
  }
}


void OBBTree::drawBVPolygon(int currentDepth, const int depth) const
{
  if( likely(this->rootNode != NULL))
    this->rootNode->drawBVPolygon(currentDepth, depth);
}


void OBBTree::drawBVBlended(int currentDepth, const int depth) const
{
  if( likely(this->rootNode != NULL))
    this->rootNode->drawBVBlended(currentDepth, depth);
}


void OBBTree::debug()
{
  PRINT(0)("\n==============================| OBBTree::debug() |===\n");
  PRINT(0)("=  Spawning Tree: Start\n");

  /* generate some test vertices */
  int const length = 3;
  sVec3D* vertList = new sVec3D[length];
  sVec3D data[length]  = {{5.0, 0.0, 0.0},{2.0, 0.0, 5.0},{14.0, 0.0, 0.0}};//, {5.0, 0.0, 1.0}, {12.0, 0.0, 8.0}, {3.0, 5.0, 4.9}};

  for(int i = 0; i < length; ++i)
    {
      vertList[i][0] = data[i][0];
      vertList[i][1] = data[i][1];
      vertList[i][2] = data[i][2];
    }

  this->spawnBVTree(1, vertList, length);

  PRINT(0)("=  Spawning Tree: Finished\n");
  PRINT(0)("=======================================================\n");

}
