/*!
    \file terrain.h
    \brief Defines and handles the terrain of the World

    \todo implement it

    The terrain should either be build from a Model a OBJModel or from a HeightMap.
*/

#ifndef _TERRAIN_H
#define _TERRAIN_H

#include "world_entity.h"

// FORWARD DEFINITION \\
class TiXmlElement;

//! A simple method to call a desired debug world.
enum DebugTerrain {TERRAIN_DAVE, TERRAIN_BENSCH};


//! A Class to handle Terrain of orxonox
class Terrain : public WorldEntity
{

 public:
  Terrain(const TiXmlElement* root = NULL);
  Terrain(const char* fileName);
  Terrain(DebugTerrain debugTerrain);
  virtual ~Terrain(void);

  void init(void);
  void loadParams(const TiXmlElement* root);

  void buildDebugTerrain(DebugTerrain debugTerrain);
  virtual void draw();

 private:
  int objectList;
};

#endif /* _TERRAIN_H */
