/*!
    \file base_object.h
    \brief Definition of the base object class.

    This is a global handler for all classes.

    \todo isA()
*/


#ifndef _BASE_OBJECT_H
#define _BASE_OBJECT_H

#include "class_list.h"
#ifndef NULL
#define NULL 0x0        //!< NULL
#endif

class TiXmlElement;

//! A class all other classes are derived from
class BaseObject {

 public:
  BaseObject (const TiXmlElement* root = NULL);
  virtual ~BaseObject ();

  void loadParams(const TiXmlElement* root);

  void setName (const char* newName);
  /** \brief returns the Name of this Object */
  inline const char* getName (void)const { return this->objectName; };

  /** \returns the className of the corresponding Object */
  inline const char* getClassName(void) const { return this->className; };
  /** \returns the classID of the corresponding Object */
  inline int getClassID(void) const { return this->classID; }

  bool isA (ClassID classID) const;
  void whatIs(void) const;

  /** \returns if the object is finalized */
  inline bool isFinalized() { return this->finalized; }


 protected:
  void setClassID(long classID);
  void setClassName(const char* className);
  void setClassID(long classID, const char* className);

  /** \brief this finalizes an object and makes it ready to be garbage collected */
  void finalize(void) { this->finalized = true; };

 private:
  const char*    className;        //!< the name of the class
  long           classID;          //!< this is the id from the class_list.h enumeration
  char*          objectName;       //!< The name of this object

  bool           finalized;        //!< is true if the object is ready to be garbage collected
};

#endif /* _BASE_OBJECT_H */
