/*! 
    \file bv_tree.h
    \brief Definition of a bounding volume tree

*/

#ifndef _OBB_TREE_NODE_H
#define _OBB_TREE_NODE_H

#include "bv_tree_node.h"



// FORWARD DEFINITION
class BoundingVolume;
class OBB;
//struct sVec3D;

//! A class that represents a bounding volume tree
class OBBTreeNode : public BVTreeNode {


 public:
  OBBTreeNode();
  virtual ~OBBTreeNode();

  virtual void spawnBVTree(const int depth, sVec3D *verticesList, const int length);

  BoundingVolume* getBV(int index) const { return (BoundingVolume*)this->bvElement; }
  inline const int getIndex() { return this->treeIndex; }  

  virtual void collideWith(const BVTree &tree);

  virtual void drawBV(int currentDepth, const int depth) const;
  virtual void drawBVPolygon(int currentDepth, const int depth) const;
  virtual void drawBVBlended(int currentDepth, const int depth) const;

  void debug();

 private:
  OBB* createBox();
  void calculateBoxAttributes(OBB* box, sVec3D* verticesList, int length);
  void forkBox(OBB* box);
  

 protected:
  OBB* bvElement;
  OBBTreeNode* nodeLeft;
  OBBTreeNode* nodeRight;


 private:
  unsigned int        treeIndex;                  //!< Index number of the BV in the tree
  sVec3D*             vertices;                   //!< pointer to the vertices data
  int                 numOfVertices;              //!< number of vertices in vertices data

};

#endif /* _OBB_TREE_NODE_H */
