/*! 
    \file cd_engine.h
    \brief Definition of the collision detection engine
    
*/

#ifndef _CD_ENGINE_H
#define _CD_ENGINE_H

#include "base_object.h"
#include "collision_defs.h"


//! the state options
typedef enum cdState
  {
    CD_DEBUG_DRAW_ALL = 1,
    CD_DEBUG_DRAW_POLYGONS = 1<<1,
    CD_DEBUG_DRAW_BLENDED = 1<<2,
    CD_DEBUG_DRAW_HIT_BV = 1<<3,
    CD_DEBUG_VERBOSE = 1<<4
  };


//! The class representing the collision detection system of orxonox
class CDEngine : public BaseObject {

 public:
  virtual ~CDEngine(void);
  /** \returns a Pointer to the only object of this Class */
  inline static CDEngine* getInstance(void) { if (!singletonRef) singletonRef = new CDEngine();  return singletonRef; };
  void init();

  void setState(int newState);
  const int getState() const { return this->state; }

  void drawBV(int currentDepth, int depth) const;
  void drawBVPolygon(int currentDepth, int depth) const;
  void drawBVBlended(int currentDepth, int depth) const;

  void checkCollisions();

 private:
  CDEngine(void);
  static CDEngine* singletonRef;

  void buildBVTree(int depth = MAX_BV_TREE_DEPTH);


 private:
  int         state;                            //!< the current state of the cd engine

};

#endif /* _CD_ENGINE_H */
