/*! 
    \file bounding_volume.h
    \brief Definition of a bounding volume for collision detection algorithms

*/

#ifndef _BOUNDING_VOLUME_H
#define _BOUNDING_VOLUME_H

#include "base_object.h"

class sVect3D;
class Vector;

//! An abstract class representing a bounding volume
class BoundingVolume : public BaseObject {

 public:
  BoundingVolume();
  virtual ~BoundingVolume();

  inline const Vector* getCenter() const { return this->center; }
  inline const Vector* getAxis () const { return this->axis; }
  inline const sVect3D* getHalfLength() const { return this->halfLength; } 

  virtual sVect3D* getVertices() const = NULL;
  virtual void mergeWith(const BoundingVolume& bv) = NULL;

  virtual void drawBV(int currentDepth, int depth) const = NULL;
  virtual void drawBVPolygon(int currentDepth, int depth) const = NULL;
  virtual void drawBVBlended(int currentDepth, int depth) const = NULL;

 private:
  Vector*             center;                     //!< Center point of box
  Vector*             axis;                       //!< Axes of oriented box [x,y,z]
  sVect3D*            halfLength;                 //!< Half lengths of the box

  unsigned int        treeIndex;                  //!< Index number of the BV in the tree
};

#endif /* _BOUNDING_VOLUME_H */
