/*! 
    \file collision.h
    \brief Definition of a collision event

*/

#ifndef _COLLISION_H
#define _COLLISION_H

#include "base_object.h"
#include "vector.h"

// FORWARD DEFINITION
class WorldEntity;
class sVec3D;
class BoundingVolume;

//! A class representing a simple collision
class Collision : public BaseObject {

 public:
  Collision();
  virtual ~Collision();

 public:
  Vector            pointOfImpact;              //!< point of impact, approximated via bounding volumes
  WorldEntity*      body;                       //!< the collision body
  BoundingVolume*   boundingVolume;             //!< reference to the bounding volume that fired the collision
};

#endif /* _COLLISION_H */
