/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "proto_singleton.h"

using namespace std;


/**
   \brief standard constructor
*/
ProtoSingleton::ProtoSingleton () 
{
   this->setClassName("ProtoSingleton");
   this->setClassID(CL_PROTO_ID, "ProtoSingleton"); 

   /* If you make a new class, what is most probably the case when you write this file
      don't forget to:
       1. Add the new file new_class.cc to the ./src/Makefile.am
       2. Add the class identifier to ./src/class_list.h eg. CL_NEW_CLASS

      Advanced Topics:
      - if you want to let your object be managed via the ObjectManager make sure to read
        the object_manager.h header comments. You will use this most certanly only if you
	make many objects of your class, like a weapon bullet.
   */
}

/**
   \brief the singleton reference to this class
*/
ProtoSingleton* ProtoSingleton::singletonRef = NULL;

/**
   \returns a Pointer to this Class
*/
ProtoSingleton* ProtoSingleton::getInstance(void)
{
  if (!ProtoSingleton::singletonRef)
    ProtoSingleton::singletonRef = new ProtoSingleton();
  return ProtoSingleton::singletonRef;
}

/**
   \brief standard deconstructor

*/
ProtoSingleton::~ProtoSingleton () 
{
  ProtoSingleton::singletonRef = NULL;

}
