/*! 
    \file physics_connection.h
    \brief Definition of The Physical Connection Class.
*/

#ifndef _PHYSICS_CONNECTION_H 
#define _PHYSICS_CONNECTION_H

#include "base_object.h"
// Forward Declaration
class PhysicsInterface;
class ParticleSystem;
class Field;

//! An enumerator for different ConnectionTypes
typedef enum PCON_Type { PCON_PhysIPhysI = 0,
			 PCON_PhysIField = 1};


// Forward Declaration

//! A class that Handles Physical Connection between subjects
class PhysicsConnection : public BaseObject
{

 public:
  PhysicsConnection(PhysicsInterface* subject, Field* field);
  //  PhysicsConnection(PhysicsInterface* partnerOne, PhysicsInterface* partnerTwo);

  virtual ~PhysicsConnection();

  void apply(void) const;

 private:
  PCON_Type type;                    //!< What kind of connection this is.
  
  PhysicsInterface* subject;         //!< The main Subject of this Connection.
  PhysicsInterface* partner2;        //!< The second partner of this Connection.
  
  Field* field;                      //!< The field to connect either subject of ParticleSystem to.
};

#endif /* _PHYSICS_CONNECTION_H */
