/*! 
    \file primitive_model.h 
    \brief a Class to handle different simple models like planes cubes spheres and so on.
    (cube is also an option of Model, but is extended here.
*/

#ifndef _PRIMITIVE_MODEL_H
#define _PRIMITIVE_MODEL_H

#include "model.h"

//! Specification of different primitives the Model knows
enum PRIMITIVE { PRIM_CUBE,
		 PRIM_SPHERE,
		 PRIM_PLANE,
		 PRIM_CYLINDER,
		 PRIM_CONE };

//! A Class to create some default Models
class PrimitiveModel : public Model {

 public:
  PrimitiveModel(PRIMITIVE type, float size = 1.0, unsigned int detail = 10);
  virtual ~PrimitiveModel();

 protected:
  void sphereModel(float size = 1.0, unsigned int detail = 10);
  void cylinderModel(float size = 1.0, unsigned int detail = 10);
  void coneModel(float size = 1.0, unsigned int detail = 10);
  void planeModel(float size = 1.0, unsigned int detail = 1);
};

#endif /* _PRIMITIVE_MODEL_H */
