/*!
  \file objModel.h
  \brief Contains the OBJ-model Class, that reads in a Model from a .obj-file
*/

#ifndef _OBJMODEL_H
#define _OBJMODEL_H

#include "model.h"

//! A Class, that handles the parsing of an obj-file, and inclusion as a Model.
class OBJModel : public Model
{
 public:
  OBJModel(const char* fileName, float scaling = 1.0);
  virtual ~OBJModel();

 private:
  ///// readin /////
  bool importFile (const char* fileName);
  bool readFromObjFile (const char* fileName);
  bool readMtlLib (const char* matFile);

 private:
  char*       objPath;     //!< The Path where the obj and mtl-file are located.
};

#endif /* _OBJ_MODEL_H */
