/*! 
    \file key_mapper.h
    \brief a construct to map player defined keys to SDL keys

*/

#ifndef _KEY_MAPPER_H
#define _KEY_MAPPER_H


#include "base_object.h"
#include "event_def.h"


//! A mapping from key-name to key-id
typedef struct orxKeyMapping
{
  int* pValue;
  char* pName;
};


//! The map class functionalities
class KeyMapper : public BaseObject {

 public:
  KeyMapper();
  virtual ~KeyMapper();

  void loadKeyBindings(const char* fileName = DEFAULT_CONFIG_FILE);

  void debug();

 private:
  int* nameToIndex (char* name);
  void mapKeys(char* name, int keyID);

 public:
  static int PEV_UP;                //!< up button
  static int PEV_DOWN;              //!< down buttton
  static int PEV_LEFT;              //!< left button
  static int PEV_RIGHT;             //!< right button
  
  static int PEV_STRAFE_LEFT;       //!< strafe left button
  static int PEV_STRAFE_RIGHT;      //!< strafe right button
  
  static int PEV_FIRE1;             //!< fire button 1
  static int PEV_FIRE2;             //!< fire button 2
  static int PEV_PREVIOUS_WEAPON;   //!< prev weapon button
  static int PEV_NEXT_WEAPON;       //!< next weapon button

  static int PEV_VIEW0;             //!< view 0 button
  static int PEV_VIEW1;             //!< view 1 button
  static int PEV_VIEW2;             //!< view 2 button
  static int PEV_VIEW3;             //!< view 3 button
  static int PEV_VIEW4;             //!< view 4 button
  static int PEV_VIEW5;             //!< view 5 button

  static int PEV_NEXT_WORLD;        //!< next world button
  static int PEV_PREVIOUS_WORLD;    //!< prev world button

  static int PEV_PAUSE;             //!< pause button
  static int PEV_QUIT;              //!< quit button

 private:
  Sint32     coord[2];              //!< temp place to save variables in nameToIndex() function
};




#endif /* _KEY_MAPPER_H */
