/*! 
    \file event_def.h
    \brief some central definitions

*/

#ifndef _EVENT_DEF_H
#define _EVENT_DEF_H

#include "SDL_keysym.h"
#include "stdincl.h"


//! these are the extended event types, that are not included in SDL_keysym
typedef enum extEventTyes
  {
    EV_MOUSE_BUTTON_LEFT = SDLK_LAST,
    EV_MOUSE_BUTTON_MIDDLE,
    EV_MOUSE_BUTTON_RIGHT,
    EV_MOUSE_BUTTON_WHEELUP,
    EV_MOUSE_BUTTON_WHEELDOWN,
    EV_MOUSE_MOTION,
    EV_JOY_AXIS_MOTION,
    EV_JOY_BALL_MOTION,
    EV_JOY_HAT_MOTION,
    EV_JOY_BUTTON,

    EV_UNKNOWN,

    EV_NUMBER
  };


//! this is an enumeration of all states of the event_handler/game
typedef enum elState
  {
    ES_GAME,           //!< the state during the game plays
    ES_GAME_MENU,      //!< state when the menu is called during game
    ES_MENU,           //!< orxonox menu state

    ES_ALL,            //!< you want to register events for all states

    ES_NUMBER,         //!< the number of states
  };


#endif /* _EVENT_DEF_H */
