/*! 
    \file event.h
    \brief an abstract event

*/

#ifndef _EVENT_H
#define _EVENT_H


#include "base_object.h"
#include "event_def.h"
#include "sdlincl.h"


//! An abstract event class
class Event : virtual public BaseObject {

 public:
  Event();
  virtual ~Event();


  int      offset;                      //!< offset in the event type array
  int      type;                        //!< the type field
  bool     bPressed;                    //!< is true, if the button/mouse was pressed, false if released
       
  Uint16   x;                           //!< x coordinate
  Uint16   y;                           //!< y coordinate
  Sint16   xRel;                        //!< relative x movement to last point
  Sint16   yRel;                        //!< relative y movement to last point
};

#endif /* _EVENT_H */
