/*! 
    \file pilot_node.h
    \brief Definition of a PilotNode
*/


#ifndef _PILOT_NODE_H
#define _PILOT_NODE_H

#include "world_entity.h"
#include "event_listener.h"

class Event;

//! The PilotNode is a node that enables the is driven by the Mouse
class PilotNode : public WorldEntity, public EventListener {

 public:
  PilotNode ();
  virtual ~PilotNode ();

  virtual void tick(float time);

  virtual void process(const Event &event);

 private:
  void move(float time);

 private:
  bool        bUp;            //!< up button pressed.
  bool        bDown;          //!< down button pressed.
  bool        bLeft;          //!< left button pressed.
  bool        bRight;         //!< right button pressed.

  int         pitch;          //!< the pitch of the node
  int         roll;           //!< the roll of the node

  Vector*     velocity;       //!< the velocity of the player.
  float       travelSpeed;    //!< the current speed of the player (to make soft movement)
  float       acceleration;   //!< the acceleration of the player.


};

#endif /* _PILOT_NODE_H */
