

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...

   bensch: added comments
*/


#include "pilot_node.h"
#include "event_handler.h"
#include "event.h"

using namespace std;

/**
   \brief standard constructor
*/
PilotNode::PilotNode () 
{
   this->setClassID(CL_PILOT_PARENT, "PilotNode");

   travelSpeed = 30.0;
   velocity = new Vector();
   bUp = bDown = bLeft = bRight = false;
}

/**
   \brief standard deconstructor
*/
PilotNode::~PilotNode () 
{

}

/** 
    \brief ticks the node
    \param time the time about whitch to tick						\
*/
void PilotNode::tick(float time)
{
  this->move(time);
}


/**
   \brief action if player moves
   \param time the timeslice since the last frame
*/
void PilotNode::move (float time)
{
  Vector accel(0.0, 0.0, 0.0);
  /* FIXME: calculating the direction and orthDirection every timeSlice is redundant! save it somewhere */
  /* calculate the direction in which the craft is heading  */
  //Vector direction (1.0, 0.0, 0.0);
  //direction = this->absDirection.apply (direction);
  //Vector orthDirection (0.0, 0.0, 1.0);
  //orthDirection = orthDirection.cross (direction);

   Quaternion q = this->getAbsDir();
   Vector direction(1,0,0);
   direction = q.apply(direction);

   

   Vector orthDirection(0,0,1);
   orthDirection = q.apply(orthDirection);
   
   if( this->bUp)
     accel = accel+(direction*acceleration);
   if( this->bDown)
     accel = accel -(direction*acceleration);
   if( this->bLeft)
     accel = accel - (orthDirection*acceleration); 
   if( this->bRight)
     accel = accel + (orthDirection*acceleration);
   
   Vector move = accel * time;
   this->shiftCoor (move);
   
   Quaternion q1(-M_PI/4 * this->roll/40000.0, Vector(0,0,1));
   Quaternion q2(-M_PI/4 * this->pitch/30000.0, Vector(0,1,0));
   //this->shiftDir(q1*q2);
   this->shiftDir(q1*q2);
}

/**
   \brief handles events
   \param event the event that occured
*/
void PilotNode::process( const Event &event)
{
  if( event.type == KeyMapper::PEV_UP)
    {
      this->bUp = event.bPressed;
    }
  else if( event.type == KeyMapper::PEV_DOWN)
    {
      this->bDown = event.bPressed;
    }
  else if( event.type == KeyMapper::PEV_RIGHT)
    {
      this->bRight= event.bPressed;
    }
  else if( event.type == KeyMapper::PEV_LEFT)
    {
      this->bLeft = event.bPressed;
    }
  else if( event.type == EV_MOUSE_MOTION)
    {
      this->pitch = event.x - 400;
      this->roll = event.y - 300;
    }
}
