/*!
  \file gui_update.h
  \brief File that holds the class that creates the update-menu.
*/

#ifndef _GUI_UPDATE_H
#define _GUI_UPDATE_H

#include "gui.h"
#include "gui_element.h"
#include "gui_gtk.h"


#define DATA_IDENTIFIER "data.oxd"

#include <stdio.h>
#ifdef HAVE_CURL
#include <curl/curl.h>
#include <curl/types.h>
#include <curl/easy.h>
#endif /* HAVE_CURL */
#ifdef HAVE_PTHREAD_H
#define _MULTI_THREADED
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */
using namespace std;

//! Class that creates the execute-Options.
class GuiUpdate : public GuiElement
{
 private:
  // Defining Variables
  char* tmpDir;                         //!< The Temporary directory.
  char* homeDir;                        //!< The Home directory.
  char* installDataDir;                 //!< Where to install the Data to.
  char* installSourceDir;               //!< Where to install the Source to.
  char* userName;                       //!< The user logged in.

  bool getSystemInfo(void);
 
  // Window creation.
  Frame* updateFrame;                   //!< The Frame that holds the updateOptions.
  Box* updateBox;                       //!< The Box that holds the updateOptions.
  CheckButton* autoUpdate;              //!< A Checkbutton to enable the automatic Updating.

  
  Button* updateDataWindowButton;       //!< A Button to update the Data of orxonox.
  Window* updateDataWindow;             //!< A Window for the data-update.
  Box* updateDataBox;                   //!< A Box for the Window for the Data-update.
  ProgressBar* updateDataBar;           //!< A Bar to display the progress of the download.
  Button* updateDataBegin;              //!< A Button to start the process.

  Button* updateSourceWindowButton;     //!< A Button to update the Source of orxonox. \todo tricky
  Window* updateSourceWindow;           //!< A Window for the Source-update.
  Box* updateSourceBox;                 //!< A Box for the Window for the Source-update.
  ProgressBar* updateSourceBar;         //!< A Bar to display the progress of the download.

  Button* test;                         //!< will be deleted soon.

#ifdef HAVE_GTK2
  static gint updateDataFunc(GtkWidget* w, GdkEventKey* event, void* info);
  static gint updateSourceFunc(GtkWidget* w, GdkEventKey* event, void* info);
#endif /* HAVE_GTK2 */

  static bool checkDataDir(const char* fileName, void* object);

#ifdef HAVE_CURL
  //! A Struct to hold information about one File to download.
  struct FileInfo
  {
    char* fileName;                     //!< The Name of the file we want to get.
    char* webRoot;                      //!< The Root of the File on The Web
    char* localRoot;                    //!< The Root directory to put the files on the local disk.
    FILE* fileHandle;                   //!< A fileHandler.

    Button* stateButton;                //!< A button that shows either start or cancel;
    long int buttonSignal;              //!< The Signal of the stateButton.
    ProgressBar* bar;                   //!< The ProgressBar, that sould be updated.
  };

  static size_t curlWriteFunc(void* ptr, size_t size, size_t nmemb, FILE* stream);
  static size_t curlReadFunc(void* ptr, size_t size, size_t nmemb, FILE* stream);
  static int curlProgressFunc(ProgressBar* bar, double totalSize, double progress, double upTotal, double upProgress);

  static CURL* curlHandle;
#ifdef HAVE_GTK2 
  static gint cancelDownload(GtkWidget* w, GdkEventKey* event, void* bar);
#endif /* HAVE_GTK2 */  
  static bool isDownloading;
  static bool downloadCanceled;

  static bool download(void* fileInfo);
  static bool downloadWithStyle(void* fileInfo);
  static void* downloadThread(void* fileInfo);
  static void* downloadThreadFinished(void* fileInfo);

  
#endif /* HAVE_CURL */

 public:
  GuiUpdate(void);
  ~GuiUpdate(void);
  
#ifdef HAVE_CURL   
  void updateDataWindowCreate(void);
  Button* updateDataWindowGetButton(void);

  void updateSourceWindowCreate(void);
  Button* updateSourceWindowGetButton(void);

  bool* checkForUpdates(void);
 
#endif /* HAVE_CURL */

};

#endif /* _GUI_UPDATE_H */
