/*! 
    \file game_loader.h
    \brief loads campaigns, worlds and all other story_entities
*/ 

#ifndef _GAME_LOADER_H
#define _GAME_LOADER_H

//#include "stdincl.h"
#include "story_def.h"
#include "comincl.h"
#include "event_listener.h"


//-----------------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------------
class Campaign;
class World;
class Camera;
class CammandNode;
class Factory;
class TiXmlElement;
class BaseObject;
class Event;

//! The GameLoader
/**
   The game loader loads all game date. this is performed in the following way:
   1. Read the structure of campaings and worlds
   2. Create the instances of the tree: here _ALL_ StoryEntities are created
      also if they are not yet used. the worlds should load their data in
      the StoryEntity::load() and StoryEntity::init() functions! NOWHERE ELSE!
      Elsewhere, all the data will be allocated at the beginning... mess...
   3. StoryEntities are load() and init() before they start
   4. once the gamloader starts the game there will be a campaing starting a
      world. this is done by callaing those StoryEntity::start()
*/
class GameLoader : public EventListener
{

 public:
  static GameLoader* getInstance();

  ErrorMessage init();
  ErrorMessage loadCampaign(const char* name);
  ErrorMessage start();
  ErrorMessage stop();
  ErrorMessage pause();
  ErrorMessage resume();
  ErrorMessage destroy();

  void nextLevel();
  void previousLevel();

  bool worldCommand(Command* cmd);
  ErrorMessage loadDebugCampaign(Uint32 campaignID);
  
  void registerFactory( Factory* factory);
  BaseObject* fabricate( TiXmlElement* data);

  void process(const Event &event);

 private:
  GameLoader ();
  ~GameLoader ();
  Uint32 startTime; //!> start time of the campaign
  static GameLoader* singletonRef;
  bool isPaused;

  Campaign* currentCampaign; //!> the current campaign playing
  
  Campaign* fileToCampaign(const char* name);

  Factory* first;
};

#endif /* _GAME_LOADER_H */
