/*! 
    \file key_mapper.h
    \brief a construct to map player defined keys to SDL keys

*/

#ifndef _KEY_MAPPER_H
#define _KEY_MAPPER_H


#include "base_object.h"
#include "event_def.h"





typedef struct orxKeyMapping
{
  int* pValue;
  char* pName;
};


//! The map class functionalities
class KeyMapper : public BaseObject {

 public:
  KeyMapper();
  virtual ~KeyMapper();

  void loadKeyBindings(const char* fileName = "~/.orxonox/orxonox.conf");

  void debug();

 private:
  int* nameToIndex (char* name);
  void mapKeys(char* name, int keyID);

 public:
  static int PEV_UP;
  static int PEV_DOWN;
  static int PEV_LEFT;
  static int PEV_RIGHT;
  
  static int PEV_STRAFE_LEFT;
  static int PEV_STRAFE_RIGHT;
  
  static int PEV_FIRE1;
  static int PEV_FIRE2;

  static int PEV_VIEW0;
  static int PEV_VIEW1;
  static int PEV_VIEW2;
  static int PEV_VIEW3;
  static int PEV_VIEW4;
  static int PEV_VIEW5;

  static int PEV_NEXT_WORLD;
  static int PEV_PREVIOUS_WORLD;

  static int PEV_PAUSE;
  static int PEV_QUIT;

 private:
  Sint32 coord[2];
};




#endif /* _KEY_MAPPER_H */
