/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
   
   This code was inspired by the command_node.cc code from Christian Meyer in revision
   4386 and earlier.
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_EVENT

#include "key_mapper.h"

#include "ini_parser.h"
#include "key_names.h"

using namespace std;



int KeyMapper::PEV_UP = -1;
int KeyMapper::PEV_DOWN = -1;
int KeyMapper::PEV_LEFT = -1;
int KeyMapper::PEV_RIGHT = -1;
int KeyMapper::PEV_STRAFE_LEFT = -1;
int KeyMapper::PEV_STRAFE_RIGHT = -1;

int KeyMapper::PEV_FIRE1 = -1;
int KeyMapper::PEV_FIRE2 = -1;

int KeyMapper::PEV_VIEW0 = -1;
int KeyMapper::PEV_VIEW1 = -1;
int KeyMapper::PEV_VIEW2 = -1;
int KeyMapper::PEV_VIEW3 = -1;
int KeyMapper::PEV_VIEW4 = -1;
int KeyMapper::PEV_VIEW5 = -1; 

int KeyMapper::PEV_NEXT_WORLD = -1;
int KeyMapper::PEV_PREVIOUS_WORLD = -1;

int KeyMapper::PEV_PAUSE = -1;
int KeyMapper::PEV_QUIT = -1;




orxKeyMapping map[] = { {&KeyMapper::PEV_UP, "Up"},
			{&KeyMapper::PEV_DOWN, "Down"},
			{&KeyMapper::PEV_LEFT, "Left"},
			{&KeyMapper::PEV_RIGHT, "Right"},
			{&KeyMapper::PEV_STRAFE_LEFT, "StrafeLeft"},
			{&KeyMapper::PEV_STRAFE_RIGHT, "StrafeRight"},
			
			{&KeyMapper::PEV_FIRE1, "Fire"},
			{&KeyMapper::PEV_FIRE1, "Fire1"},
			{&KeyMapper::PEV_FIRE2, "Fire2"},

			{&KeyMapper::PEV_VIEW0, "view0"},
			{&KeyMapper::PEV_VIEW1, "view1"},
			{&KeyMapper::PEV_VIEW2, "view2"},
			{&KeyMapper::PEV_VIEW3, "view3"},
			{&KeyMapper::PEV_VIEW4, "view4"},
			{&KeyMapper::PEV_VIEW5, "view5"},

			{&KeyMapper::PEV_NEXT_WORLD, "Next-World"},
			{&KeyMapper::PEV_PREVIOUS_WORLD, "Prev-World"},

			{&KeyMapper::PEV_PAUSE, "Pause"},
			{&KeyMapper::PEV_QUIT, "Quit"},
                        {NULL, NULL}};


/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
KeyMapper::KeyMapper () 
{
   this->setClassID(CL_KEY_MAPPER, "KeyMapper"); 
}


/**
   \brief standard deconstructor

*/
KeyMapper::~KeyMapper () 
{
  // delete what has to be deleted here
}

\
/**
   \brief loads new key bindings from a file
   \param filename: The path and name of the file to load the bindings from
*/
void KeyMapper::loadKeyBindings (const char* fileName)
{
  FILE* stream;
  
  PRINTF(4)("Loading key bindings from %s\n", fileName);
  
  // create parser
  IniParser parser(fileName);
  if( parser.getSection (CONFIG_SECTION_PLAYER "1") == -1)
    {
      PRINTF(1)("Could not find key bindings " CONFIG_SECTION_PLAYER"1 in %s\n", fileName);
      return;
    }
  // allocate empty lookup table
  
  char namebuf[256];
  char valuebuf[256];
  memset (namebuf, 0, 256);
  memset (valuebuf, 0, 256);
  int* index;
  
  while( parser.nextVar (namebuf, valuebuf) != -1)
    {
      PRINTF(3)("Keys: Parsing %s, %s now.\n", namebuf, valuebuf);
      index = nameToIndex (valuebuf);
      this->mapKeys(namebuf, index[1]);

      /*
      switch( index[0])
	{
	case 0:
	  this->mapKeys(namebuf, index[1]);
	  break;
	case 1:
	  this->mapKeys(namebuf, index[1]);
	  break;
	default:
	  break;
	}
      */
      memset (namebuf, 0, 256);
      memset (valuebuf, 0, 256);
    }


  // PARSE MISC SECTION
  if( parser.getSection (CONFIG_SECTION_MISC_KEYS) == -1)
    {
      PRINTF(1)("Could not find key bindings in %s\n", fileName);
      return;
    }

  while( parser.nextVar (namebuf, valuebuf) != -1)
    {
      PRINTF(3)("MISC: Parsing %s, %s now.\n", namebuf, valuebuf);
      index = nameToIndex (valuebuf);     
      this->mapKeys(namebuf, index[1]);
      /*
      switch( index[0])
	{
	case 0:
	  this->mapKeys(namebuf, index[1]);
	  break;
	case 1:
	this->mapKeys(namebuf, index[1]);
	  break;
	default:
	  break;
	}
      */
      memset (namebuf, 0, 256);
      memset (valuebuf, 0, 256);
    }
}



int* KeyMapper::nameToIndex (char* name)
{
  coord[0] = -1;
  coord[1] = -1;
  int c;
  if( (c = keynameToSDLK (name)) != -1)
    {
      coord[1] = c;
      coord[0] = 0;
    }
  if( (c = buttonnameToSDLB (name)) != -1)
    {
      coord[1] = c;
      coord[0] = 1;
    }
  return coord;
}



void KeyMapper::mapKeys(char* name, int keyID)
{
  for(int i = 0; map[i].pValue != NULL; ++i )
    {
      if( !strcmp (name, map[i].pName)) { *map[i].pValue = keyID; break;}
    }
}


void KeyMapper::debug()
{
  //PRINT(0)("\n==========================| KeyMapper::debug() |===\n");  

  for(int i = 0; map[i].pValue != NULL; ++i)
    {
      PRINT(0)("%s = %i\n",map[i].pName, *map[i].pValue);
    }

  //PRINT(0)("=======================================================\n");        
}
