

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer
   
   bensch: renamed the file
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "physics_interface.h"
#include "physics_engine.h"

#include "field.h"
#include "p_node.h"

#include "list.h"
#include "string.h"
#include "stdincl.h"

using namespace std;


/**
   \brief standard constructor
*/
PhysicsInterface::PhysicsInterface () 
{
  //   this->setClassName ("PhysicsInterface");
   this->mass = 0;
   this->massChildren = 0;
   this->forceSum = Vector(0, 0, 0);

   PhysicsEngine::getInstance()->addPhysicsInterface(this);
}


/**
   \brief standard deconstructor

*/
PhysicsInterface::~PhysicsInterface () 
{
   PhysicsEngine::getInstance()->removePhysicsInterface(this);
}

/**
   \brief recalculates the total mass of all the children of this node

   (only availiable for PNodes)
*/
void PhysicsInterface::recalcMass()
{
  PNode* massCalcPNode = dynamic_cast<PNode*>(this);  //! \todo not sure if this will work ....
  float massSum = 0;
  
  tIterator<PNode>* iterator = massCalcPNode->children->getIterator();
  PNode* pn = iterator->nextElement();
  while( pn != NULL) 
    { 
      // todo: find out if children are PhysicsInterface in an efficient way
      if (strcmp( pn->getClassName(), "PhysicsInterface")) {
	massSum += ((PhysicsInterface*)pn)->getTotalMass();
      }
      pn = iterator->nextElement();
    }
  delete iterator;
	
  if (massSum != this->massChildren ) {
    this->massChildren = massSum;
    if (strcmp( massCalcPNode->parent->getClassName(), "PhysicsInterface"))
      ((PhysicsInterface*)massCalcPNode->parent)->recalcMass();
  } else {
    this->massChildren = massSum;
  }
}
	
	
void PhysicsInterface::applyField(Field* field, float dt)
{
  //  this->forceSum += force;
}

void PhysicsInterface::tickPhys( float dt )
{
  Vector acc = this->forceSum / ( this->massChildren + this->mass );
  // todo: introduce kinematics
}
