/*! 
    \file physics_engine.h
    \brief Definition of the ... singleton Class
    
*/

#ifndef _PHYSICS_ENGINE_H
#define _PHYSICS_ENGINE_H

#include "base_object.h"

#include "physics_connection.h"
#include "physics_interface.h"

// Forward Declaration
template<class T> class tList;


//! A default singleton class.
class PhysicsEngine : public BaseObject {

 public:
  static PhysicsEngine* getInstance(void);
  virtual ~PhysicsEngine(void);

  void addPhysicsInterface(PhysicsInterface* physicsInterface);
  void removePhysicsInterface(PhysicsInterface* physicsInterface);


  void addConnection(PhysicsConnection* connection);
  void removeConnection(PhysicsConnection* connection);

  void tick(float dt);

  void debug(void) const;

 private:
  PhysicsEngine(void);
  static PhysicsEngine* singletonRef;      //!< the singleton reference of the PhysicsEngine

  tList<PhysicsInterface>* interfaces;     //!< a list of physically based objects
  tList<PhysicsConnection>* connections;   //!< a list of physical connections
};



#endif /* _PHYSICS_ENGINE_H */
