/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_PHYSICS

#include "physics_engine.h"

#include "debug.h"

#include "list.h"

using namespace std;


/**
   \brief standard constructor
*/
PhysicsEngine::PhysicsEngine() 
{
   this->setClassName ("PhysicsEngine");

   this->connections = new tList<PhysicsConnection>;
   this->interfaces = new tList<PhysicsInterface>;
}

/**
   \brief the singleton reference to this class
*/
PhysicsEngine* PhysicsEngine::singletonRef = NULL;

/**
   \returns a Pointer to this Class
*/
PhysicsEngine* PhysicsEngine::getInstance(void)
{
  if (!PhysicsEngine::singletonRef)
    PhysicsEngine::singletonRef = new PhysicsEngine();
  return PhysicsEngine::singletonRef;
}

/**
   \brief standard deconstructor

*/
PhysicsEngine::~PhysicsEngine () 
{
  PhysicsEngine::singletonRef = NULL;
}


/**
   \brief adds a PhysicsInterface to the list of handeled physicsInterfaces
   \param physicsInterface the interface to add

   this is normally done in the constructor of any PhysicsInterface
*/
void PhysicsEngine::addPhysicsInterface(PhysicsInterface* physicsInterface)
{
  this->interfaces->add(physicsInterface);
}

/**
   \brief removes a PhysicsInterface from the list of handeled physicsInterfaces
   \param physicsInterface the interface to remove

   this is normally done in the destructor of any PhysicsInterface
*/
void PhysicsEngine::removePhysicsInterface(PhysicsInterface* physicsInterface)
{
  this->interfaces->remove(physicsInterface);  
}

/**
   \brief adds A Physical Connection to the List of Connections
   \param connection the Connection to add
   
   Usually this is done through the constructor of PhysicshConnections
*/
void PhysicsEngine::addConnection(PhysicsConnection* connection)
{
  this->connections->add(connection);
}

/**
   \brief removes A Physical Connection from the List of Connections
   \param connection the Connection to remove
   
   Usually this is done through the destructor of PhysicsConnections
*/
void PhysicsEngine::removeConnection(PhysicsConnection* connection)
{
  this->connections->remove(connection);
}





/**
   \brief Steps through all the Connections and Ticks them
   \param dt The time Passed in Seconds

   This function brings a flow into the whole animation
*/
void PhysicsEngine::tick(float dt)
{
  tIterator<PhysicsConnection>* iterator = this->connections->getIterator();
  PhysicsConnection* enumConn = iterator->nextElement();
  while (enumConn)
    {
      enumConn->apply(dt);
      enumConn = iterator->nextElement();
    }
  delete iterator;
}



/**
   \brief print out interesting debug information of this class
*/
void PhysicsEngine::debug(void) const
{
  PRINT(0)("====================================\n");
  PRINT(0)("= Physics-Engine debug information =\n");
  PRINT(0)("====================================\n");
  PRINT(0)(" reference: %p\n", this);
  PRINT(0)(" number of Interfaces: %d\n", this->interfaces->getSize());
  PRINT(0)(" number of Connections: %d\n", this->connections->getSize());

  PRINT(0)("==============================PHYS==\n");
}
