/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "physics_connection.h"

#include "physics_engine.h"

#include "field.h"
#include "particle_system.h"
#include "physics_interface.h"

using namespace std;

PhysicsConnection::PhysicsConnection(PhysicsInterface* subject, Field* field)
{
  this->type = PCON_PhysIField;
  this->subject = subject;
  this->field = field;

  PhysicsEngine::getInstance()->addConnection(this);
}


/**
   \brief standard deconstructor

*/
PhysicsConnection::~PhysicsConnection () 
{
  PhysicsEngine::getInstance()->removeConnection(this);
}

/** 
    \brief applies the Force to some Object.
    \param dt The time to apply in Seconds
*/
void PhysicsConnection::apply(const float& dt) const
{
  if (likely(this->type == PCON_PhysIField && this->field->getMagnitude() != 0.0))
      this->subject->applyField(this->field, dt);
  else ;
}
