/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "gui_video.h"

#include "gui_gtk.h"
#include "sdlincl.h"
#include <stdlib.h>

/**
   \brief Creates the Video-Option-Frame
*/
GuiVideo::GuiVideo(void)
{
  Frame* videoFrame;        //!< The Frame that holds the video options.

  videoFrame = new Frame("Video-Options:");
  videoFrame->setGroupName("video");
  {
    Box* videoBox;            //!< The Box that holds the video options.

    videoBox = new Box('v');
    {
      CheckButton* fullscreen;  //!< CheckButton for fullscreen-mode
      Menu* resolution;         //!< Menu for the resolution
      CheckButton* wireframe;   //!< CheckButton for wireframe Mode.

      fullscreen = new CheckButton(CONFIG_NAME_FULLSCREEN);
      fullscreen->setFlagName("windowed", "q", 1);
      fullscreen->setDescription("Starts orxonox in windowed mode");
      fullscreen->saveability();
      videoBox->fill(fullscreen);
      resolution = new Menu(CONFIG_NAME_RESOLUTION);
      getResolutions(resolution);
      resolution->saveability();
      resolution->setFlagName("resolution", "r", 0);
      resolution->setDescription("Sets the resolution of orxonox");
      videoBox->fill(resolution);
      wireframe = new CheckButton(CONFIG_NAME_WIREFRAME);
      wireframe->setFlagName("wireframe", "w", 0);
      wireframe->setDescription("Starts orxonox in wireframe mode");
      wireframe->saveability();
      videoBox->fill(wireframe);

      videoBox->fill(advancedWindowCreate());
    }
    videoFrame->fill(videoBox);
  }
  setMainWidget(videoFrame);
}

/**
   \brief Destructs the Video-stuff
*/
GuiVideo::~GuiVideo(void)
{
  // nothing to do here.
}

/**
   \brief Creates a window, and all it contains for the Source-update.
*/
Widget* GuiVideo::advancedWindowCreate(void)
{
  // advanced-Performance-Options
  Window* advancedWindow;   //!< A Window to display advanced options.
  Button* advancedButton;   //!< A Button to open the Advanced Video Performance Window.
  // the button, that opens this Window.
  advancedButton = new Button("advanced");

  // the Window itself
  advancedWindow = new Window("Advanced Video Options");
  advancedWindow->setGroupName(CONFIG_SECTION_VIDEO_ADVANCED);
  {
    Box* advancedBox;         //!< A Box to pack the options into.

    advancedBox = new Box('v');
    {
      CheckButton* shadows;     //!< CheckButton for shadows
      CheckButton* fog;         //!< CheckButton for fog.
      CheckButton* reflections; //!< CheckButton for reflections
      CheckButton* textures;    //!< CheckButton for textures
      Menu* textureDetail;      //!< Menu for the Texture-Detail.
      Label* modelDetailLabel;  //!< Label for model-detail.
      Menu* modelDetail;        //!< model-detail.
      CheckButton* particles;   //!< If the Particles should be enabled
      Label* antiAliasingLabel; //!< Label for the anti-aliasing mode.
      Menu* antiAliasing;       //!< Menu for the Antialiasing-mode.
      Label* filterMethodLabel; //!< Label for filtering-Method.
      Menu* filterMethod;       //!< Menu for filtering Method.
      Button* closeButton;      //!< A Button to close the Advanced-settingsWindow.

      // Advanced Performance Options
      shadows = new CheckButton(CONFIG_NAME_SHADOWS);
      shadows->saveability();
      advancedBox->fill(shadows);
      
      fog = new CheckButton(CONFIG_NAME_FOG);
      fog->saveability();
      advancedBox->fill(fog);
      
      reflections = new CheckButton(CONFIG_NAME_REFLECTIONS);
      reflections->saveability();
      advancedBox->fill(reflections);
      
      textures = new CheckButton(CONFIG_NAME_TEXTURES);
      textures->saveability();
      advancedBox->fill(textures);
      
      textureDetail = new Menu(CONFIG_NAME_TEXTURE_DETAIL, "low", "medium", "high", "lastItem");
      textureDetail->setDefaultValue(1);
      textureDetail->saveability();
      advancedBox->fill(textureDetail);
      
      modelDetailLabel = new Label(CONFIG_NAME_MODEL_DETAIL);
      advancedBox->fill(modelDetailLabel);
      modelDetail = new Menu(CONFIG_NAME_MODEL_DETAIL, "low", "high", "lastItem");
      modelDetail->setDefaultValue(1);
      modelDetail->saveability();
      advancedBox->fill(modelDetail);
      
      particles = new CheckButton(CONFIG_NAME_PARTICLES_ENABLED);
      particles->saveability();
      particles->setDefaultValue(1);
      advancedBox->fill(particles);

      antiAliasingLabel = new Label("Anti-Aliasing-depth:");
      advancedBox->fill(antiAliasingLabel);
      antiAliasing = new Menu(CONFIG_NAME_ANTI_ALIASING, "0", "1", "2", "4", "8",  "lastItem");
      antiAliasing->setDefaultValue(2);
      antiAliasing->saveability();
      advancedBox->fill(antiAliasing);
      
      filterMethodLabel = new Label("Filtering Method:");
      advancedBox->fill(filterMethodLabel);
      filterMethod = new Menu(CONFIG_NAME_FILTER_METHOD, "none", "linear", "bilinear", "trilinear", "anisortopic", "lastItem");
      filterMethod->setDefaultValue(1);
      filterMethod->saveability();
      advancedBox->fill(filterMethod);


  
      closeButton = new Button("close");
#ifdef HAVE_GTK2
      closeButton->connectSignal("button_press_event", advancedWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

      advancedBox->fill(closeButton);
    }
    advancedWindow->fill(advancedBox);
  }
#ifdef HAVE_GTK2
  advancedButton->connectSignal("button_press_event", advancedWindow, Window::windowOpen);
  advancedWindow->connectSignal("destroy", advancedWindow, Window::windowClose);
  advancedWindow->connectSignal("delete_event", advancedWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
  Window::addWindow(advancedWindow);

  return advancedButton;
}

/**
   \brief sets all resolutions to the menu
   \param menu the Menu to set The resolutions to.
*/
void GuiVideo::getResolutions(Menu* menu)
{
  SDL_Init(SDL_INIT_VIDEO);
  SDL_Rect **modes;
  int i;
  int x = 0,y =0; // check for difference
  char tmpChar[100];
  
  /* Get available fullscreen/hardware modes */
  modes=SDL_ListModes(NULL, SDL_FULLSCREEN|SDL_HWSURFACE);
  
  /* Check is there are any modes available */
  if(modes == (SDL_Rect **)0){
    PRINTF(2)("No video-modes available!\n");
    exit(-1);
  }
  
  /* Check if our resolution is restricted */
  if(modes == (SDL_Rect **)-1){
    PRINTF(2)("All resolutions available.\n");
  }
  else{
    /* Print valid modes */
    PRINT(5)("Available Modes\n");
    for(i = 0; modes[i] ;++i)
      {
	if (x != modes[i]->w || y != modes[i]->h)
	  { 
	    PRINTF(5)("  %d x %d\n", modes[i]->w, modes[i]->h);
	    sprintf(tmpChar, "%dx%d", modes[i]->w, modes[i]->h);
	    menu->addItem(tmpChar);
	    x = modes[i]->w; y = modes[i]->h;
	  }
      }
  }
  SDL_Quit();
}
