/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*! 
    \file debug.h
    \brief Handles output to console for different Verbose-Modes.

    There are two main modes HARD and SOFT. HARD is precessed during compileTime where SOFT is for runtime.
    \li HARD: One can choose between different modes. see: // DEFINE_MODULES 
    \li SOFT: If you want each module can have its own variable for processing. just pass it to DEBUG_MODULE_SOFT
*/ 

#ifndef _DEBUG_H
#define _DEBUG_H

#include "confincl.h"

#include <stdio.h>

// DEFINE ERROR MODES
#define NO              0
#define ERR             1
#define WARN            2
#define INFO            3
#define DEBUG           4
#define vDEBUG          5

extern int verbose;

//definitions
#ifndef MODULAR_DEBUG
#define HARD_DEBUG_LEVEL DEBUG
#define SOFT_DEBUG_LEVEL verbose
#else /* MODULAR_DEBUG */
#ifndef DEBUG_MODULE_SOFT 
#define SOFT_DEBUG_LEVEL verbose
#else /* DEBUG_MODULE_SOFT */
#define SOFT_DEBUG_LEVEL DEBUG_MODULE_SOFT
#endif /* DEBUG_MODULE_SOFT */

#ifndef DEBUG_SPECIAL_MODULE
#define HARD_DEBUG_LEVEL DEBUG
#else /* DEBUG_SPECIAL_MODULE */
// DEFINE MODULES
#define DEBUG_MODULE_ORXONOX            0
#define DEBUG_MODULE_WORLD              0
#define DEBUG_MODULE_PNODE              0
#define DEBUG_MODULE_WORLD_ENTITY       0
#define DEBUG_MODULE_COMMAND_NODE       0
#define DEBUG_MODULE_GRAPHICS           0
#define DEBUG_MODULE_LOAD               2

#define DEBUG_MODULE_IMPORTER           0
#define DEBUG_MODULE_TRACK_MANAGER      0
#define DEBUG_MODULE_GARBAGE_COLLECTOR  0
#define DEBUG_MODULE_OBJECT_MANAGER     3
#define DEBUG_MODULE_LIGHT              0
#define DEBUG_MODULE_PLAYER             1
#define DEBUG_MODULE_WEAPON             0
#define DEBUG_MODULE_MATH               0
#define DEBUG_MODULE_FONT               1
#define DEBUG_MODULE_ANIM               1
#define DEBUG_MODULE_PARTICLE           1
#define DEBUG_MODULE_EVENT              3

#define DEBUG_MODULE_NULL_PARENT        0


#define HARD_DEBUG_LEVEL DEBUG_SPECIAL_MODULE
#endif /* DEBUG_SPECIAL_MODULE */
#endif /* MODULAR_DEBUG */

///////////////////////////////////////////////////
/// PRINTF: prints with filename and linenumber ///
///////////////////////////////////////////////////
#define PRINTFNO      PRINTF0
#define PRINTFERR     PRINTF1
#define PRINTFWARN    PRINTF2
#define PRINTFINFO    PRINTF3
#define PRINTFDEBUG   PRINTF4
#define PRINTFVDEBUG  PRINTF5

#ifdef DEBUG

#define PRINTF(x) \
           PRINTF ## x

#if HARD_DEBUG_LEVEL >= ERR
#define PRINTF1 \
    if (SOFT_DEBUG_LEVEL >= ERR) \
      printf("ERROR::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF1 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= WARN
#define PRINTF2 \
     if (SOFT_DEBUG_LEVEL >= WARN) \
       printf("WARNING::%s:%d:", __FILE__, __LINE__) && printf
         
#else 
#define PRINTF2 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= INFO
#define PRINTF3 \
     if (SOFT_DEBUG_LEVEL >= INFO) \
       printf("INFO::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF3 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= DEBUG
#define PRINTF4 \
     if (SOFT_DEBUG_LEVEL >= DEBUG) \
       printf("DEBUG::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF4 if (NO)
#endif
     
#if HARD_DEBUG_LEVEL >= vDEBUG
#define PRINTF5 \
     if (SOFT_DEBUG_LEVEL >= vDEBUG) \
       printf("VERYDEBUG::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINTF5 if (NO)
#endif
    
#else  
#define PRINTF(x) if (NO)
#endif

#define PRINTF0 \
    printf("%s:%d::", __FILE__, __LINE__) && printf


///////////////////////////////////////////////////
///  PRINT: just prints output as is            ///
///////////////////////////////////////////////////
#define PRINTNO      PRINT0
#define PRINTERR     PRINT1
#define PRINTWARN    PRINT2
#define PRINTINFO    PRINT3
#define PRINTDEBUG   PRINT4
#define PRINTVDEBUG  PRINT5

#ifdef  DEBUG
#define PRINT(x) \
  PRINT ## x

#if HARD_DEBUG_LEVEL >= ERR
#define PRINT1	\
  if (SOFT_DEBUG_LEVEL >= ERR)	\
    printf
#else 
#define PRINT1 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= WARN
#define PRINT2 \
  if (SOFT_DEBUG_LEVEL >= WARN) \
    printf

#else 
#define PRINT2 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= INFO
#define PRINT3 \
  if (SOFT_DEBUG_LEVEL >= INFO) \
    printf
#else 
#define PRINT3 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= DEBUG
#define PRINT4 \
  if (SOFT_DEBUG_LEVEL >= DEBUG) \
    printf
#else 
#define PRINT4 if (NO)
#endif

#if HARD_DEBUG_LEVEL >= vDEBUG
#define PRINT5 \
     if (SOFT_DEBUG_LEVEL >= vDEBUG) \
       printf("VERYDEBUG::%s:%d:", __FILE__, __LINE__) && printf
#else 
#define PRINT5 if (NO)
#endif


#else  
#define PRINT(x) if (NO)
#endif

#define PRINT0 \
  printf

#endif /* _DEBUG_H */
