/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   this file extends the framework file, so it renders what i want.
*/

#include "framework.h"

#include "physics_engine.h"
#include "particle_engine.h"


void Framework::moduleInit(int argc, char** argv)
{
  // Creating a Test Particle System
  ParticleSystem* system = new ParticleSystem(100000, PARTICLE_SPRITE);
  system->setRadius(0,0,0,0);
  system->setLifeSpan(0);
  system->setConserve(1.0);

  // Creating a Test Particle Emitter
  ParticleEmitter* emitter = new ParticleEmitter(Vector(0 , 1, 0));
  emitter->setEmissionRate(0);
  emitter->setEmissionVelocity(0,0);
  emitter->setSpread(0,0);
  emitter->setType(EMITTER_DOT);
  emitter->setSize(0);
  // Add the Flow from the Emitter into the System
  ParticleEngine::getInstance()->addConnection(emitter, system);
}

void Framework::moduleEventHandler(SDL_Event* event)
{
  switch (event->type)
    {
    case SDL_KEYDOWN:
      switch (event->key.keysym.sym)
	{
	case SDLK_i:
	  ParticleEngine::getInstance()->debug();
	  break;
	}
    }
}

void Framework::moduleTick(float dt)
{
  ParticleEngine::getInstance()->tick(dt);
}

void Framework::moduleDraw(float dt)
{
  ParticleEngine::getInstance()->draw(dt);
}


void Framework::moduleHelp(void) const
{
  PRINT(0)("\n");
  PRINT(0)("i - Particle-state Information\n\n");
  PRINT(0)("\n");

}

int emitterChange(GtkWidget* nonInterest, void* widget)
{
  Option* option = (Option*) widget;
  const char* name = option->getTitle();
  char* value = option->save();

  ParticleEmitter* tmpEmit = ParticleEngine::getInstance()->getEmitterByNumber(1);
  if (tmpEmit)
    {
      if (!strcmp(name, "EmissionRate"))
	{
	  tmpEmit->setEmissionRate(atof(value));
	  PRINT(3)("EmissionRate set to %f\n", atof(value));
	}
      else if (!strcmp(name, "Velocity"))
	{
	  tmpEmit->setEmissionVelocity(atof(value));
	  PRINT(3)("Velocity set to %f\n", atof(value));
	}
      else if(!strcmp(name, "SpreadAngle"))
	{
	  tmpEmit->setSpread(atof(value));
	  PRINT(3)("SpreadAngle set to %f\n", atof(value));
	}
      else if(!strcmp(name, "EmitterType"))
	{
	  if (!strcmp(value, "EMITTER_DOT"))
	    tmpEmit->setType(EMITTER_DOT);
	  else if (!strcmp(value, "EMITTER_PLANE"))
	    tmpEmit->setType(EMITTER_PLANE);
	  else if (!strcmp(value, "EMITTER_CUBE"))
	    tmpEmit->setType(EMITTER_CUBE);
	  PRINT(3)("EmitterType set to %s\n", value);
	}
      else if(!strcmp(name, "EmitterSize"))
	{
	  tmpEmit->setSize(atof(value));
	  PRINT(3)("EmitterSize set to %f\n", atof(value));
	}
    }
  delete value;
}


int systemChange(GtkWidget* nonInterest, void* widget)
{
  Option* option = (Option*) widget;
  const char* name = option->getTitle();
  char* value = option->save();
  printf("%s\n", value);

  ParticleSystem* tmpSys = ParticleEngine::getInstance()->getSystemByNumber(1);
  if (tmpSys)
    {
      if (!strcmp(name, "StartRadius"))
	{
	  tmpSys->setRadius(atof(value), tmpSys->getEndRadius());
	  PRINT(3)("ParticleStartRadius set to %f\n", atof(value));
	}
      else if (!strcmp(name, "EndRadius"))
	{
	  tmpSys->setRadius( tmpSys->getStartRadius(), atof(value));
	  PRINT(3)("ParticleEndRadius set to %f\n", atof(value));
	}

      else if (!strcmp(name, "LifeSpan"))
	{
	  tmpSys->setLifeSpan(atof(value));
	  PRINT(3)("ParticleLifeSpan set to %f\n", atof(value));
	}

      else if (!strcmp(name, "ConserveFactor"))
	{
	  tmpSys->setConserve(atof(value));
	  PRINT(3)("ParticleConserveFactor set to %f\n", atof(value));
	}

      else if (!strcmp(name, "ParticleType"))
	{
	  if (!strcmp(value, "PARTICLE_DOT"))
	    tmpSys->setType(PARTICLE_DOT);
	  else if (!strcmp(value, "PARTICLE_SPARK"))
	    tmpSys->setType(PARTICLE_SPARK);
	  else if (!strcmp(value, "PARTICLE_SPRITE"))
	    tmpSys->setType(PARTICLE_SPRITE);

	  PRINT(3)("ParticleType set to %s\n", value);
	}

      else if (!strcmp(name, "InheritSpeed"))
	{
	  tmpSys->setInheritSpeed(atof(value));
	  PRINT(3)("ParticleInheritSpeed set to %f\n", atof(value));
	}

    }
  delete value;
}


void Framework::moduleInitGui(int argc, char** argv)
{
  Window* guiMainWindow = NULL;
  
  initGUI(0, NULL);
  
  guiMainWindow = new Window("ParticlesFUN");
  {
    Box* windowBox = new Box('v');
    {
      Frame* emitterFrame = new Frame("emitter-settings");
      {
	Box* emitterBox = new Box('v');
	{
	  emitterBox->fill(new Label("EmissionRate"));
	  Slider* EmissionRate = new Slider("EmissionRate", 0, 1000);
	  EmissionRate->connectSignal("value_changed", (void*)EmissionRate, emitterChange );
	  emitterBox->fill(EmissionRate);
	  
	  emitterBox->fill(new Label("Velocity"));
	  Slider* velocity = new Slider("Velocity", 0, 20);
	  velocity->setExactness(2);
	  velocity->connectSignal("value_changed", (void*)velocity, emitterChange );
	  emitterBox->fill(velocity);
	  
	  emitterBox->fill(new Label("SpreadAngle"));
	  Slider* SpreadAngle = new Slider("SpreadAngle", 0, M_PI);
	  SpreadAngle->setExactness(3);
	  SpreadAngle->connectSignal("value_changed", (void*)SpreadAngle, emitterChange );
	  emitterBox->fill(SpreadAngle);

	  emitterBox->fill(new Label("EmitterType"));
	  Menu* EmitterType = new Menu("EmitterType");
	  EmitterType->addItem("EMITTER_DOT");
	  EmitterType->addItem("EMITTER_PLANE");
	  EmitterType->addItem("EMITTER_CUBE");
	  EmitterType->load("EMITTER_DOT");
	  EmitterType->connectSignal("changed", (void*)EmitterType, emitterChange );
	  emitterBox->fill(EmitterType);

	  emitterBox->fill(new Label("EmitterSize"));
	  Slider* EmitterSize = new Slider("EmitterSize", 0, 100);
	  EmitterSize->setExactness(1);
	  EmitterSize->connectSignal("value_changed", (void*)EmitterSize, emitterChange );
	  emitterBox->fill(EmitterSize);
	}
	emitterFrame->fill(emitterBox);
      }
      windowBox->fill(emitterFrame);
      
      Frame* systemFrame = new Frame("system-settings");
      {
	Box* systemBox = new Box('v');
	{
	  systemBox->fill(new Label("StartRadius"));
	  Slider* StartRadius = new Slider("StartRadius", 0, 10);
	  StartRadius->setExactness(3);
	  StartRadius->connectSignal("value_changed", (void*)StartRadius, systemChange );
	  systemBox->fill(StartRadius);

	  systemBox->fill(new Label("EndRadius"));
	  Slider* EndRadius = new Slider("EndRadius", 0, 10);
	  EndRadius->setExactness(3);
	  EndRadius->connectSignal("value_changed", (void*)EndRadius, systemChange );
	  systemBox->fill(EndRadius);

	  systemBox->fill(new Label("LifeSpan"));
	  Slider* LifeSpan = new Slider("LifeSpan", 0, 10);
	  LifeSpan->setExactness(3);
	  LifeSpan->connectSignal("value_changed", (void*)LifeSpan, systemChange );
	  systemBox->fill(LifeSpan);
	  
	  systemBox->fill(new Label("ConserveFactor"));
	  Slider* ConserveFactor = new Slider("ConserveFactor", 0, 1);
	  ConserveFactor->setExactness(3);
	  ConserveFactor->load("1.0");
	  ConserveFactor->connectSignal("value_changed", (void*)ConserveFactor, systemChange );
	  systemBox->fill(ConserveFactor);

	  systemBox->fill(new Label("ParticleType"));
	  Menu* ParticleType = new Menu("ParticleType");
	  ParticleType->addItem("PARTICLE_DOT");
	  ParticleType->addItem("PARTICLE_SPARK");
	  ParticleType->addItem("PARTICLE_SPRITE");
	  ParticleType->load("PARTICLE_SPRITE");
	  ParticleType->connectSignal("changed", (void*)ParticleType, systemChange );	  
	  systemBox->fill(ParticleType);
	  
	  systemBox->fill(new Label("InheritSpeed"));
	  Slider* InheritSpeed = new Slider("InheritSpeed", 0, 1);
	  InheritSpeed->setExactness(3);
	  InheritSpeed->connectSignal("value_changed", (void*)InheritSpeed, systemChange );
	  systemBox->fill(InheritSpeed);


	}
	systemFrame->fill(systemBox);
      }
      windowBox->fill(systemFrame);
      
      Button* quitButton = new Button("quit");
      
      quitButton->connectSignal("clicked", NULL, quitGui);
      //  Window::mainWindow->connectSignal("remove", this, GuiExec::quitGui);
      Window::mainWindow->connectSignal("destroy", NULL, quitGui);
      
      windowBox->fill(quitButton);
    }
    guiMainWindow->fill(windowBox);
  }
  Window::mainWindow->showall();
  Window::mainWindow->setSize(300, 500);
}
