

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "satellite.h"

#include "objModel.h"
#include "list.h"
#include "vector.h"


using namespace std;

/**
   \brief standard constructor
*/
Satellite::Satellite (Vector axis, float speed)
{
  this->setClassID(CL_SATELLITE);
  this->model = (Model*) ResourceManager::getInstance()->load("cube", RP_LEVEL);
  this->speed = speed;
  this->axis = new Vector();
  *this->axis = axis;
}

/**
   \brief standard destructor
*/
Satellite::~Satellite ()
{
  // if( collisioncluster != NULL) delete collisioncluster;
  if (this->model)
    ResourceManager::getInstance()->unload(this->model);
}


/**
   \brief this method is called every frame
   \param time: the time in seconds that has passed since the last tick
   
   Handle all stuff that should update with time inside this method (movement, animation, etc.)
*/
void Satellite::tick(float time) 
{
  float w = this->speed * M_PI;

  Quaternion rotation(w * time, *this->axis); 
  Quaternion v = this->getRelDir();
  
  this->setRelDir(v * rotation);
}


/**
   \brief the entity is drawn onto the screen with this function
   
   This is a central function of an entity: call it to let the entity painted to the screen. Just override this function with whatever you want to be drawn.
*/
void Satellite::draw() 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  /* translate */
  glTranslatef (this->getAbsCoor ().x, 
		this->getAbsCoor ().y, 
		this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  
  this->model->draw();
  glPopMatrix();

}

