

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/


#include "character_attributes.h"
#include "stdincl.h" 

using namespace std;


/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
CharacterAttributes::CharacterAttributes () 
{
   this->setClassID(CL_CHARACTER_ATTRIBUTES);
}


/**
   \brief standard deconstructor

*/
CharacterAttributes::~CharacterAttributes () 
{
}


/*=====================health=====================*/

/**
   \brief sets the health of the character
   \param helath
 */
void CharacterAttributes::setHealth(int health)
{
  this->health = health;
}

/**
   \brief adds health to the charater
   \param health
   \returns health that couldnt be added due to healt limit, 0 if everything worked as normal
 */
int CharacterAttributes::addHealth(int health)
{
  this->health += health;
  int rest = this->healthMax - this->health;
  if( rest < 0)
    {
      this->health = this->healthMax;
      return 0;
    }
  return rest;
}

/**
   \brief remove health due to damager for example
   \param amount of health
   \returns false if health is zero -> dead
 */
bool CharacterAttributes::substractHealth(int health)
{
  this->health -= health;
  if( this->health < 0)
    {
      this->health = 0;
      return false;
    }
  return true;
}

/**
   \brief gets the current amount of health
   \returns health
 */
int CharacterAttributes::getHealth()
{
  return this->health;
}


/**
   \brief sets maximum health 
   \param health

   if healthMax = 0 -> unlimited
 */
void CharacterAttributes::setHealthMax(int healthMax)
{
  this->healthMax = healthMax;
}

/**
   \brief gets health maximium
   \returns the health maximum
 */
int CharacterAttributes::getHealthMax()
{
  return this->healthMax;
}


/*======================armor/ shields===================== */
/**
   \brief sets the shild strength
   \param strength
 */
void CharacterAttributes::setShieldStrength(int shieldStrength)
{
  this->shieldStrength = shieldStrength;
}

/**
   \brief adds shield strength
   \param strength
   
   there is currently no limit to shieldstrength
 */
void CharacterAttributes::addShieldStrength(int shiledStrength)
{
  this->shieldStrength += shieldStrength;
}

/**
   \brief substracts shield strength
   \param strength
   \returns amount of shield strength below zero after substraction. Magic: Troumble. if everything works allright, it returns 0
 */
int CharacterAttributes::substractShieldStrength(int shieldStrength)
{
  int rest = this->shieldStrength -= shieldStrength;
  if( rest < 0)
    {
      this->shieldStrength = 0;
      return -rest;
    }
  return 0;
}

/**
   \brief gets shield strength
   \returns the shield strength
 */
int CharacterAttributes::getShieldStrength()
{
  return this->shieldStrength;
}


/*=====================damage=====================*/
/**
   \brief sets the amount of base damage dealt to all aircrafts
   \param damage

   There can be a difference between arms that hit a ground/air craft. Eg.
   a tank will react differently to explosives than something in the air
   (think about physics)
 */
void CharacterAttributes::setDamageToAirCraft(int damage)
{
  this->damageToAirCraft = damage;
}

/**
   \brief gets the amount of base damage
   \returns base damage to aircrafts

   There can be a difference between arms that hit a ground/air craft. Eg.
   a tank will react differently to explosives than something in the air
   (think about physics)
 */
int CharacterAttributes::getDamageToAirCraft()
{
  return this->damageToAirCraft;
}


/**
   \brief sets the amount of base damage dealt to all groundcrafts
   \param damage

   There can be a difference between arms that hit a ground/air craft. Eg.
   a tank will react differently to explosives than something in the air
   (think about physics)
 */
void CharacterAttributes::setDamageToGroundCraft(int damage)
{
  this->damageToGroundCraft = damage;
}

/**
   \briefgets the amount of base damage
   \returns base damage to groundcrafts

   There can be a difference between arms that hit a ground/air craft. Eg.
   a tank will react differently to explosives than something in the air
   (think about physics)
 */
int CharacterAttributes::getDamageToGroundCraft()
{
  return this->damageToGroundCraft;
}


/**
   \brief sets the damage modifier to the damage that is dealed via laser weapons
   \param modifier [0..1]

   eg. the damage is calculated after: damage = modifier * damageToGroundCraft
 */
void CharacterAttributes::setDamageLaserModifier(float modifier)
{
  this->damageLaserModifier = modifier;
}

/**
   \brief gets the damage modifier to the damage that is dealed via laser weapons
   \returns damage modifier

   eg. the damage is calculated after: damage = modifier * damageToGroundCraft
 */
float CharacterAttributes::getDamageLaserModifier()
{
  return this->damageLaserModifier;
}


/**
   \brief sets the damage modifier to the damage that is dealed via plasma weapons
   \param damage modifier

   eg. the damage is calculated after: damage = modifier * damageToGroundCraft
 */
void CharacterAttributes::setDamagePlasmaModifier(float modifier)
{
  this->damagePlasmaModifier = modifier;
}

/**
   \brief gets the damage modifier to the damage that is dealed plasma weapons
   \returns damage modifier

   eg. the damage is calculated after: damage = modifier * damageToGroundCraft
 */
float CharacterAttributes::getDamagePlasmaModifier()
{
  return this->damagePlasmaModifier;
}


/**
   \brief sets the damage modifier to the damage that is dealed via explosives
   \param damage modifier

   eg. the damage is calculated after: damage = modifier * damageToGroundCraft
 */
void CharacterAttributes::setDamageExplosiveModifier(float modifier)
{
  this->damageExplosiveModifier = modifier;
}

/**
   \brief sets the damage modifier to the damage that is dealed via explosives
   \returns damage modifier

   eg. the damage is calculated after: damage = modifier * damageToGroundCraft
 */
float CharacterAttributes::getDamageExplosiveModifier()
{
  return this->damageExplosiveModifier;
}


/*=====================energy=====================*/
/**
   \brief sets the amount of energy 
   \param energy
 */
void CharacterAttributes::setEnergy(int energy)
{
  this->energy = energy;
}

/**
   \brief adds energy to the system
   \param amount of energy
   \returns amount of energy that is too much due to energy limit
 */
int CharacterAttributes::addEnergy(int addEnergy)
{
  this->energy += addEnergy;
  int rest = this->energyMax - this->energy;
  if(rest < 0)
    {
      this->energy = 0;
      return rest;
    }
  return 0;
}

/**
   \brief substracts energy from a system
   \param amount of energy
   \returns false if there is no energy anymore
 */
bool CharacterAttributes::substractEnergy(int subEnergy)
{
  this->energy -= subEnergy;
  if(this->energy < 0)
    {
      this->energy = 0;
      return false;
    }
  return true;
}

/**
   \brief gets the amount of energy 
   \returns energy
 */
int CharacterAttributes::getEnergy()
{
  return this->energy;
}


/**
   \brief sets the energy consumption
   \param amount of energy
*/
void CharacterAttributes::setEnergyConsumption(int energy)
{
  this->energyConsumption = energy;
}

/**
   \brief gets the energy consumption
   \returns amount of energy
*/
int CharacterAttributes::getEnergyConsumption()
{
  return this->energyConsumption;
}
  

/**
   \brief sets the maximum energy level
   \param amount of energy
*/
void CharacterAttributes::setEnergyMax(int energy)
{
  this->energyMax = energy;
}

/**
   \brief gets the max energy level
   \returns amount of energy
*/
int CharacterAttributes::getEnergyMax()
{
  return this->energyMax;
}
