/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_OBJECT_MANAGER

#include "object_manager.h"
#include "garbage_collector.h"
#include "list.h"

#include "projectile.h"

using namespace std;


/**
   \brief standard constructor
*/
ObjectManager::ObjectManager () 
{
  this->setClassID(CL_OBJECT_MANAGER);
  
  this->managedObjectList = new tList<BaseObject>*[CL_NUMBER];
  for(int i = 0; i < CL_NUMBER; ++i)
    {
      this->managedObjectList[i] = NULL;
    }

  this->garbageCollector = GarbageCollector::getInstance();
}

/**
   \brief the singleton reference to this class
*/
ObjectManager* ObjectManager::singletonRef = NULL;

/**
   \returns a Pointer to this Class
*/
ObjectManager* ObjectManager::getInstance(void)
{
  if (!ObjectManager::singletonRef)
    ObjectManager::singletonRef = new ObjectManager();
  return ObjectManager::singletonRef;
}


/**
   \brief standard deconstructor

*/
ObjectManager::~ObjectManager () 
{
  ObjectManager::singletonRef = NULL;
}


void ObjectManager::addToDeadList(classList index, BaseObject* object)
{
  if( likely(this->managedObjectList[index] != NULL))
    this->managedObjectList[index]->add(object);
  else
    PRINTF(0)(" Error: unable to add object to the list nr. %i: no list initialized - ignoring\n", index);
}


BaseObject* ObjectManager::getFromDeadList(classList index, int number)
{
  if( likely(this->managedObjectList[index] != NULL))
    {
      BaseObject* obj = this->managedObjectList[index]->firstElement();
      this->managedObjectList[index]->remove(obj);
      return obj;
    }
  else
    PRINTF(0)(" Error: unable to get object from the list nr. %i: no elements initialized - ignoring\n", index);
}


void ObjectManager::debug()
{
  PRINT(0)("\n==========================| ObjectManager::debug() |===\n");
  PRINT(0)("=  Number of registerable classes: %i\n", CL_NUMBER );  
  PRINT(0)("=  Currently cached objects: \n");
  for(int i = 0; i < CL_NUMBER; ++i)
    {
      if( this->managedObjectList[i] != NULL)
	PRINT(0)("=   o Class Nr. %i has cached %i object(s)\n", i, this->managedObjectList[i]->getSize());
      else
	PRINT(0)("=   o Class Nr. %i has cached 0 object(s)\n", i);
    }
  PRINT(0)("=======================================================\n");
}
