/*! 
    \file class_list.h
    \brief list of orxonox classes

    this is used by the ObjectManager to identify and load important classes
*/

#ifndef _CLASS_LIST_H
#define _CLASS_LIST_H


//! list of all classes to be loadable in via the ObjectManager
typedef enum classList 
{
  CL_PARENT,
  CL_HELPER_PARENT,
  CL_NULL_PARENT,
  CL_CAMERA,
  CL_CAMERA_TARGET,

  CL_WORLD_ENTITY,
  CL_ENVIRONEMENT,
  CL_NPC,
  CL_PLAYER,
  CL_POWER_UP,
  CL_PROJECTILE,
  CL_SATELLITE,
  CL_SKYBOX,
  CL_SKYSPHERE,
  CL_TERRAIN,
  CL_TEST_BULLET,
  CL_TEST_ENTITY,
  CL_TEST_GUN,
  CL_WEAPON,
  CL_CHARACTER_ATTRIBUTES,

  CL_STORY_ENTITY,
  CL_CAMPAIGN,
  CL_WORLD,
  CL_TRACK_MANAGER,
  CL_TRACK_NODE,

  CL_ANIMATION,
  CL_ANIMATION3D,
  CL_ANIMATION_PLAYER,

  CL_ARRAY,
  CL_BASE_OBJECT,
  CL_CURVE,
  CL_VECTOR,
  CL_FACTORY,
  CL_INI_PARSER,
  CL_LIST,
  CL_SUBSTRING,
  CL_LOAD_PARAM,

  CL_OBJECT_MANAGER,
  CL_RESOURCE_MANAGER,
  CL_GARBAGE_COLLECTOR,
  CL_GAME_LOADER,
  CL_COMMAND_NODE,

  CL_GRAPHICS_ENGINE,  
  CL_TEXT_ENGINE,
  CL_TEXT,
  CL_GLMENU_IMAGE_SCREEN,
  CL_LIGHT,
  CL_LIGHT_MANAGER,
  CL_MATERIAL,
  CL_MD2Model,
  CL_MODEL,
  CL_OBJMODEL,
  CL_PROMITIVE_MODEL,
  
  CL_PARTICLE_EMITTER,
  CL_PARTICLE_ENGINE,
  CL_PARTICLE_SYSTEM,
  

  CL_NUMBER
};


#endif /* _CLASS_LIST_H */
